// for explanation of types, see
// https://docs.google.com/spreadsheets/d/1qwfw1AOED7WiElOCJwt_VHo_JaDhr6ZIiJMqjRCXajQ/edit#gid=1797422705
"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
function _export(target, all) {
    for(var name in all)Object.defineProperty(target, name, {
        enumerable: true,
        get: all[name]
    });
}
_export(exports, {
    ACTION_DATA_ELEMENT_TYPES: function() {
        return ACTION_DATA_ELEMENT_TYPES;
    },
    BLOOD_PRESSURE: function() {
        return BLOOD_PRESSURE;
    },
    CHARTING_CORE_TYPE_TO_ID: function() {
        return CHARTING_CORE_TYPE_TO_ID;
    },
    CHARTING_DATA_ELEMENT_IDS: function() {
        return CHARTING_DATA_ELEMENT_IDS;
    },
    CHARTING_SURVEY_TYPES: function() {
        return CHARTING_SURVEY_TYPES;
    },
    COMPLEX_CORE_DATA_ELEMENT_TYPES: function() {
        return COMPLEX_CORE_DATA_ELEMENT_TYPES;
    },
    LINE: function() {
        return LINE;
    },
    NON_ANSWERABLE_DATA_ELEMENT_TYPES: function() {
        return NON_ANSWERABLE_DATA_ELEMENT_TYPES;
    },
    PATIENT_DATA_FIELD_LOCATIONS: function() {
        return PATIENT_DATA_FIELD_LOCATIONS;
    },
    PROGRAM_DATA_ELEMENT_TYPES: function() {
        return PROGRAM_DATA_ELEMENT_TYPES;
    },
    PROGRAM_DATA_ELEMENT_TYPE_VALUES: function() {
        return PROGRAM_DATA_ELEMENT_TYPE_VALUES;
    },
    PROGRAM_REGISTRY_FIELD_LOCATIONS: function() {
        return PROGRAM_REGISTRY_FIELD_LOCATIONS;
    },
    READONLY_DATA_FIELDS: function() {
        return READONLY_DATA_FIELDS;
    },
    RESULT_COLORS: function() {
        return RESULT_COLORS;
    },
    SURVEY_TYPES: function() {
        return SURVEY_TYPES;
    },
    VITALS_DATA_ELEMENT_IDS: function() {
        return VITALS_DATA_ELEMENT_IDS;
    },
    VITAL_CHARTS: function() {
        return VITAL_CHARTS;
    }
});
const PROGRAM_DATA_ELEMENT_TYPES = {
    TEXT: 'FreeText',
    MULTILINE: 'Multiline',
    RADIO: 'Radio',
    SELECT: 'Select',
    MULTI_SELECT: 'MultiSelect',
    AUTOCOMPLETE: 'Autocomplete',
    DATE: 'Date',
    DATE_TIME: 'DateTime',
    SUBMISSION_DATE: 'SubmissionDate',
    INSTRUCTION: 'Instruction',
    NUMBER: 'Number',
    BINARY: 'Binary',
    CHECKBOX: 'Checkbox',
    CALCULATED: 'CalculatedQuestion',
    CONDITION: 'ConditionQuestion',
    RESULT: 'Result',
    SURVEY_ANSWER: 'SurveyAnswer',
    SURVEY_RESULT: 'SurveyResult',
    SURVEY_LINK: 'SurveyLink',
    PHOTO: 'Photo',
    PATIENT_DATA: 'PatientData',
    USER_DATA: 'UserData',
    PATIENT_ISSUE: 'PatientIssue',
    GEOLOCATE: 'Geolocate',
    COMPLEX_CHART_INSTANCE_NAME: 'ComplexChartInstanceName',
    COMPLEX_CHART_DATE: 'ComplexChartDate',
    COMPLEX_CHART_TYPE: 'ComplexChartType',
    COMPLEX_CHART_SUBTYPE: 'ComplexChartSubtype'
};
const PROGRAM_DATA_ELEMENT_TYPE_VALUES = Object.values(PROGRAM_DATA_ELEMENT_TYPES);
const COMPLEX_CORE_DATA_ELEMENT_TYPES = [
    PROGRAM_DATA_ELEMENT_TYPES.COMPLEX_CHART_INSTANCE_NAME,
    PROGRAM_DATA_ELEMENT_TYPES.COMPLEX_CHART_DATE,
    PROGRAM_DATA_ELEMENT_TYPES.COMPLEX_CHART_TYPE,
    PROGRAM_DATA_ELEMENT_TYPES.COMPLEX_CHART_SUBTYPE
];
const NON_ANSWERABLE_DATA_ELEMENT_TYPES = [
    PROGRAM_DATA_ELEMENT_TYPES.INSTRUCTION,
    PROGRAM_DATA_ELEMENT_TYPES.RESULT
];
const ACTION_DATA_ELEMENT_TYPES = [
    PROGRAM_DATA_ELEMENT_TYPES.PATIENT_ISSUE,
    PROGRAM_DATA_ELEMENT_TYPES.PATIENT_DATA
];
const SURVEY_TYPES = {
    PROGRAMS: 'programs',
    REFERRAL: 'referral',
    OBSOLETE: 'obsolete',
    VITALS: 'vitals',
    SIMPLE_CHART: 'simpleChart',
    COMPLEX_CHART: 'complexChart',
    COMPLEX_CHART_CORE: 'complexChartCore'
};
const CHARTING_SURVEY_TYPES = [
    SURVEY_TYPES.SIMPLE_CHART,
    SURVEY_TYPES.COMPLEX_CHART,
    SURVEY_TYPES.COMPLEX_CHART_CORE
];
const PDE_DATE_RECORDED = 'pde-PatientVitalsDate';
const PDE_TEMPERATURE = 'pde-PatientVitalsTemperature';
const PDE_WEIGHT = 'pde-PatientVitalsWeight';
const PDE_HEIGHT = 'pde-PatientVitalsHeight';
const PDE_SBP = 'pde-PatientVitalsSBP';
const PDE_DBP = 'pde-PatientVitalsDBP';
const PDE_HEART_RATE = 'pde-PatientVitalsHeartRate';
const PDE_RESPIRATORY_RATE = 'pde-PatientVitalsRespiratoryRate';
const PDE_SPO2 = 'pde-PatientVitalsSPO2';
const PDE_AVPU = 'pde-PatientVitalsAVPU';
const VITALS_DATA_ELEMENT_IDS = {
    dateRecorded: PDE_DATE_RECORDED,
    temperature: PDE_TEMPERATURE,
    weight: PDE_WEIGHT,
    height: PDE_HEIGHT,
    sbp: PDE_SBP,
    dbp: PDE_DBP,
    heartRate: PDE_HEART_RATE,
    respiratoryRate: PDE_RESPIRATORY_RATE,
    spo2: PDE_SPO2,
    avpu: PDE_AVPU
};
const CHARTING_DATA_ELEMENT_IDS = {
    dateRecorded: 'pde-PatientChartingDate',
    complexChartInstanceName: 'pde-ComplexChartInstanceName',
    complexChartDate: 'pde-ComplexChartDate',
    complexChartType: 'pde-ComplexChartType',
    complexChartSubtype: 'pde-ComplexChartSubtype'
};
const CHARTING_CORE_TYPE_TO_ID = {
    [PROGRAM_DATA_ELEMENT_TYPES.COMPLEX_CHART_INSTANCE_NAME]: CHARTING_DATA_ELEMENT_IDS.complexChartInstanceName,
    [PROGRAM_DATA_ELEMENT_TYPES.COMPLEX_CHART_DATE]: CHARTING_DATA_ELEMENT_IDS.complexChartDate,
    [PROGRAM_DATA_ELEMENT_TYPES.COMPLEX_CHART_TYPE]: CHARTING_DATA_ELEMENT_IDS.complexChartType,
    [PROGRAM_DATA_ELEMENT_TYPES.COMPLEX_CHART_SUBTYPE]: CHARTING_DATA_ELEMENT_IDS.complexChartSubtype
};
const BLOOD_PRESSURE = 'BLOOD_PRESSURE';
const LINE = 'LINE';
const VITAL_CHARTS = {
    [PDE_TEMPERATURE]: LINE,
    [PDE_WEIGHT]: LINE,
    [PDE_HEIGHT]: LINE,
    [PDE_SBP]: BLOOD_PRESSURE,
    [PDE_DBP]: BLOOD_PRESSURE,
    [PDE_HEART_RATE]: LINE,
    [PDE_RESPIRATORY_RATE]: LINE,
    [PDE_SPO2]: LINE,
    [PDE_AVPU]: LINE
};
// utility function for when a model's fields are all a direct match for their survey configs
const makeLookupFields = (model, fields)=>Object.fromEntries(fields.map((f)=>[
            f,
            [
                model,
                f
            ]
        ]));
const PATIENT_DATA_FIELD_LOCATIONS = {
    registrationClinicalStatus: [
        'PatientProgramRegistration',
        'clinicalStatusId'
    ],
    programRegistrationStatus: [
        'PatientProgramRegistration',
        'registrationStatus'
    ],
    registrationClinician: [
        'PatientProgramRegistration',
        'clinicianId'
    ],
    registeringFacility: [
        'PatientProgramRegistration',
        'registeringFacilityId'
    ],
    registrationCurrentlyAtVillage: [
        'PatientProgramRegistration',
        'villageId'
    ],
    registrationCurrentlyAtFacility: [
        'PatientProgramRegistration',
        'facilityId'
    ],
    ...makeLookupFields('Patient', [
        'firstName',
        'middleName',
        'lastName',
        'culturalName',
        'dateOfBirth',
        'dateOfDeath',
        'sex',
        'email',
        'villageId'
    ]),
    ...makeLookupFields('PatientAdditionalData', [
        'placeOfBirth',
        'bloodType',
        'primaryContactNumber',
        'secondaryContactNumber',
        'maritalStatus',
        'cityTown',
        'streetVillage',
        'educationalLevel',
        'socialMedia',
        'title',
        'birthCertificate',
        'drivingLicense',
        'passport',
        'emergencyContactName',
        'emergencyContactNumber',
        'registeredById',
        'motherId',
        'fatherId',
        'nationalityId',
        'countryId',
        'divisionId',
        'subdivisionId',
        'medicalAreaId',
        'nursingZoneId',
        'settlementId',
        'ethnicityId',
        'occupationId',
        'religionId',
        'patientBillingTypeId',
        'countryOfBirthId'
    ])
};
const READONLY_DATA_FIELDS = {
    AGE: 'age',
    AGE_WITH_MONTHS: 'ageWithMonths',
    FULL_NAME: 'fullName'
};
const PROGRAM_REGISTRY_FIELD_LOCATIONS = Object.keys(PATIENT_DATA_FIELD_LOCATIONS).filter((key)=>PATIENT_DATA_FIELD_LOCATIONS[key][0] === 'PatientProgramRegistration');
const RESULT_COLORS = {
    green: '#83d452',
    yellow: '#ffea5a',
    orange: '#fe8c00',
    red: '#ff2222',
    deepred: '#971a1a',
    purple: '#971a1a'
};

//# sourceMappingURL=surveys.js.map