"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
function _export(target, all) {
    for(var name in all)Object.defineProperty(target, name, {
        enumerable: true,
        get: all[name]
    });
}
_export(exports, {
    populateDbFromTallyFile: function() {
        return populateDbFromTallyFile;
    },
    readJSON: function() {
        return readJSON;
    }
});
const _fs = require("fs");
const _lodash = require("lodash");
const _index = require("../helpers/index.js");
function _getRequireWildcardCache(nodeInterop) {
    if (typeof WeakMap !== "function") return null;
    var cacheBabelInterop = new WeakMap();
    var cacheNodeInterop = new WeakMap();
    return (_getRequireWildcardCache = function(nodeInterop) {
        return nodeInterop ? cacheNodeInterop : cacheBabelInterop;
    })(nodeInterop);
}
function _interop_require_wildcard(obj, nodeInterop) {
    if (!nodeInterop && obj && obj.__esModule) {
        return obj;
    }
    if (obj === null || typeof obj !== "object" && typeof obj !== "function") {
        return {
            default: obj
        };
    }
    var cache = _getRequireWildcardCache(nodeInterop);
    if (cache && cache.has(obj)) {
        return cache.get(obj);
    }
    var newObj = {
        __proto__: null
    };
    var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor;
    for(var key in obj){
        if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) {
            var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null;
            if (desc && (desc.get || desc.set)) {
                Object.defineProperty(newObj, key, desc);
            } else {
                newObj[key] = obj[key];
            }
        }
    }
    newObj.default = obj;
    if (cache) {
        cache.set(obj, newObj);
    }
    return newObj;
}
// TODO: this needs way more data groups
const MODEL_TO_FUNCTION = {
    Appointment: {
        POST: _index.createRepeatingAppointment
    },
    Patient: {
        POST: _index.createPatient
    },
    Encounter: {
        POST: _index.createEncounter
    },
    ImagingRequest: {
        POST: _index.createImagingRequest
    },
    Invoice: {
        POST: _index.createInvoice
    },
    LabRequest: {
        POST: _index.createLabRequest
    },
    ProgramRegistry: {
        POST: _index.createProgramRegistry
    },
    Survey: {
        POST: _index.createSurveyResponse
    },
    Tasking: {
        POST: _index.createTask
    },
    Vaccine: {
        POST: _index.createAdministeredVaccine
    },
    ReportDefinition: {
        POST: _index.createDbReport
    }
};
const readJSON = async (path)=>{
    const data = await _fs.promises.readFile(path, 'utf8');
    return JSON.parse(data);
};
const populateDbFromTallyFile = async (models, tallyFilePath)=>{
    await (0, _index.generateImportData)(models);
    const { default: pLimit } = await Promise.resolve().then(()=>/*#__PURE__*/ _interop_require_wildcard(require("p-limit")));
    const tallyJson = await readJSON(tallyFilePath);
    const tallies = Object.entries(tallyJson);
    const limit = pLimit(10);
    const limited = (fn)=>limit(()=>fn({
                models,
                limit
            }).then(print('.'), print('!', true)));
    for (const [n, [model, tally]] of tallies.entries()){
        let calls = [];
        const { POST: postCount, PUT: putCount } = tally;
        const { POST: postFn, PUT: putFn } = MODEL_TO_FUNCTION[model] ?? {};
        if (postFn) {
            console.log(`Simulating POST ${model}`, postCount, 'times');
            calls = calls.concat((0, _lodash.times)(postCount, ()=>limited(postFn)));
        } else if (postCount) {
            console.error(`Missing mapping for ${model}.POST`);
        }
        if (putFn) {
            console.log(`Simulating PUT ${model}`, putCount, 'times');
            calls = calls.concat((0, _lodash.times)(putCount, ()=>limited(putFn)));
        } else if (putCount) {
            console.error(`Missing mapping for ${model}.PUT`);
        }
        if (calls.length > 0) {
            await Promise.all(calls);
            console.log();
            console.log('[', n + 1, '/', tallies.length, ']', 'Simulated', calls.length, model, 'endpoint calls');
        }
    }
};
function print(char, reject = false) {
    return (value)=>{
        process.stdout.write(char);
        if (reject) {
            throw value;
        } else {
            return value;
        }
    };
}

//# sourceMappingURL=populateFromLogTally.js.map