"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
function _export(target, all) {
    for(var name in all)Object.defineProperty(target, name, {
        enumerable: true,
        get: all[name]
    });
}
_export(exports, {
    down: function() {
        return down;
    },
    up: function() {
        return up;
    }
});
const _sequelize = /*#__PURE__*/ _interop_require_wildcard(require("sequelize"));
function _getRequireWildcardCache(nodeInterop) {
    if (typeof WeakMap !== "function") return null;
    var cacheBabelInterop = new WeakMap();
    var cacheNodeInterop = new WeakMap();
    return (_getRequireWildcardCache = function(nodeInterop) {
        return nodeInterop ? cacheNodeInterop : cacheBabelInterop;
    })(nodeInterop);
}
function _interop_require_wildcard(obj, nodeInterop) {
    if (!nodeInterop && obj && obj.__esModule) {
        return obj;
    }
    if (obj === null || typeof obj !== "object" && typeof obj !== "function") {
        return {
            default: obj
        };
    }
    var cache = _getRequireWildcardCache(nodeInterop);
    if (cache && cache.has(obj)) {
        return cache.get(obj);
    }
    var newObj = {
        __proto__: null
    };
    var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor;
    for(var key in obj){
        if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) {
            var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null;
            if (desc && (desc.get || desc.set)) {
                Object.defineProperty(newObj, key, desc);
            } else {
                newObj[key] = obj[key];
            }
        }
    }
    newObj.default = obj;
    if (cache) {
        cache.set(obj, newObj);
    }
    return newObj;
}
const INDEX = [
    'fhir_materialise_jobs',
    [
        'upstream_id',
        'resource'
    ]
];
const TABLE_NAME = 'fhir_materialise_jobs';
async function up(query) {
    await query.createTable(TABLE_NAME, {
        id: {
            type: _sequelize.DataTypes.UUID,
            allowNull: false,
            primaryKey: true,
            defaultValue: _sequelize.default.fn('uuid_generate_v4')
        },
        created_at: {
            type: _sequelize.default.DATE,
            defaultValue: _sequelize.default.fn('current_timestamp', 3),
            allowNull: false
        },
        updated_at: {
            type: _sequelize.default.DATE,
            defaultValue: _sequelize.default.fn('current_timestamp', 3),
            allowNull: false
        },
        deleted_at: {
            type: _sequelize.default.DATE,
            allowNull: true
        },
        // queue-related fields
        status: {
            type: _sequelize.DataTypes.STRING,
            defaultValue: 'Queued',
            allowNull: false
        },
        started_at: _sequelize.DataTypes.DATE,
        completed_at: _sequelize.DataTypes.DATE,
        errored_at: _sequelize.DataTypes.DATE,
        error: _sequelize.DataTypes.TEXT,
        // data fields
        upstream_id: _sequelize.DataTypes.STRING,
        resource: _sequelize.DataTypes.STRING
    });
    await query.addIndex(...INDEX, {
        unique: 'true',
        where: {
            status: 'Queued'
        }
    });
}
async function down(query) {
    await query.dropTable(TABLE_NAME);
}

//# sourceMappingURL=1670295248635-addFhirMaterialiseJobTable.js.map