"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
Object.defineProperty(exports, "Attachment", {
    enumerable: true,
    get: function() {
        return Attachment;
    }
});
const _sequelize = require("sequelize");
const _constants = require("@tamanu/constants");
const _Model = require("./Model");
let Attachment = class Attachment extends _Model.Model {
    static initModel({ primaryKey, ...options }) {
        super.init({
            id: primaryKey,
            type: _sequelize.DataTypes.TEXT,
            size: _sequelize.DataTypes.INTEGER,
            data: _sequelize.DataTypes.BLOB
        }, {
            ...options,
            syncDirection: _constants.SYNC_DIRECTIONS.PUSH_TO_CENTRAL_THEN_DELETE
        });
    }
    static sanitizeForDatabase({ data, ...restOfValues }) {
        return {
            ...restOfValues,
            data: Buffer.from(data, 'base64')
        };
    }
    // Attachments don't sync on facility. Strangely, they do actually sync as
    // their upload mechanism on mobile. We should probably change this to be consistent on both
    // https://github.com/beyondessential/tamanu/pull/3352
    static sanitizeForCentralServer(values) {
        return this.sanitizeForDatabase(values);
    }
};

//# sourceMappingURL=Attachment.js.map