"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
Object.defineProperty(exports, "patientSecondaryIdRoutes", {
    enumerable: true,
    get: function() {
        return patientSecondaryIdRoutes;
    }
});
const _express = /*#__PURE__*/ _interop_require_default(require("express"));
const _expressasynchandler = /*#__PURE__*/ _interop_require_default(require("express-async-handler"));
const _lodash = require("lodash");
const _errors = require("@tamanu/shared/errors");
function _interop_require_default(obj) {
    return obj && obj.__esModule ? obj : {
        default: obj
    };
}
const patientSecondaryIdRoutes = _express.default.Router();
patientSecondaryIdRoutes.get('/:id/secondaryId', (0, _expressasynchandler.default)(async (req, res)=>{
    const { models, params } = req;
    const { rows, count } = await models.PatientSecondaryId.findAndCountAll({
        where: {
            patientId: params.id
        }
    });
    // Check read permissions on every patient secondary ID
    rows.forEach((secondaryId)=>{
        req.checkPermission('read', secondaryId);
    });
    res.send({
        count,
        data: rows
    });
}));
patientSecondaryIdRoutes.put('/:id/secondaryId/:secondaryIdId', (0, _expressasynchandler.default)(async (req, res)=>{
    const { models, params } = req;
    const secondaryId = await models.PatientSecondaryId.findByPk(params.secondaryIdId);
    if (!secondaryId) throw new _errors.NotFoundError();
    req.checkPermission('write', secondaryId);
    const updatableFields = (0, _lodash.pick)(req.body, [
        'value',
        'visibilityStatus',
        'typeId'
    ]);
    await secondaryId.update(updatableFields);
    res.send(secondaryId);
}));
patientSecondaryIdRoutes.post('/:id/secondaryId', (0, _expressasynchandler.default)(async (req, res)=>{
    const { models, params } = req;
    const patient = await models.Patient.findByPk(params.id);
    if (!patient) throw new _errors.NotFoundError();
    req.checkPermission('create', 'PatientSecondaryId');
    const secondaryId = await models.PatientSecondaryId.create({
        value: req.body.value,
        visibilityStatus: req.body.visibilityStatus,
        typeId: req.body.typeId,
        patientId: params.id
    });
    res.send(secondaryId);
}));

//# sourceMappingURL=patientSecondaryId.js.map