"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
function _export(target, all) {
    for(var name in all)Object.defineProperty(target, name, {
        enumerable: true,
        get: all[name]
    });
}
_export(exports, {
    diagnosticReportHandler: function() {
        return diagnosticReportHandler;
    },
    immunizationHandler: function() {
        return immunizationHandler;
    },
    patientHandler: function() {
        return patientHandler;
    },
    singleDiagnosticReportHandler: function() {
        return singleDiagnosticReportHandler;
    },
    singleImmunizationHandler: function() {
        return singleImmunizationHandler;
    },
    singlePatientHandler: function() {
        return singlePatientHandler;
    }
});
const _expressasynchandler = /*#__PURE__*/ _interop_require_default(require("express-async-handler"));
const _errors = require("@tamanu/shared/errors");
const _getHL7Payload = require("./getHL7Payload");
const _patient = require("./patient");
const _labTest = require("./labTest");
const _schema = /*#__PURE__*/ _interop_require_wildcard(require("./schema"));
const _administeredVaccine = require("./administeredVaccine");
function _interop_require_default(obj) {
    return obj && obj.__esModule ? obj : {
        default: obj
    };
}
function _getRequireWildcardCache(nodeInterop) {
    if (typeof WeakMap !== "function") return null;
    var cacheBabelInterop = new WeakMap();
    var cacheNodeInterop = new WeakMap();
    return (_getRequireWildcardCache = function(nodeInterop) {
        return nodeInterop ? cacheNodeInterop : cacheBabelInterop;
    })(nodeInterop);
}
function _interop_require_wildcard(obj, nodeInterop) {
    if (!nodeInterop && obj && obj.__esModule) {
        return obj;
    }
    if (obj === null || typeof obj !== "object" && typeof obj !== "function") {
        return {
            default: obj
        };
    }
    var cache = _getRequireWildcardCache(nodeInterop);
    if (cache && cache.has(obj)) {
        return cache.get(obj);
    }
    var newObj = {
        __proto__: null
    };
    var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor;
    for(var key in obj){
        if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) {
            var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null;
            if (desc && (desc.get || desc.set)) {
                Object.defineProperty(newObj, key, desc);
            } else {
                newObj[key] = obj[key];
            }
        }
    }
    newObj.default = obj;
    if (cache) {
        cache.set(obj, newObj);
    }
    return newObj;
}
function patientHandler() {
    return (0, _expressasynchandler.default)(async (req, res)=>{
        const { Patient } = req.store.models;
        const payload = await (0, _getHL7Payload.getHL7Payload)({
            req,
            querySchema: _schema.patient.query,
            model: Patient,
            getWhere: _patient.getPatientWhereClause,
            getInclude: ()=>[
                    {
                        association: 'additionalData'
                    }
                ],
            bundleId: 'patients',
            toHL7List: (patients)=>(0, _patient.patientToHL7PatientList)(req, patients),
            extraOptions: {
                paranoid: false
            }
        });
        res.send(payload);
    });
}
function diagnosticReportHandler() {
    return (0, _expressasynchandler.default)(async (req, res)=>{
        const payload = await (0, _getHL7Payload.getHL7Payload)({
            req,
            querySchema: _schema.diagnosticReport.query,
            model: req.store.models.LabTest,
            getWhere: ()=>({}),
            getInclude: (displayId, { status })=>[
                    {
                        association: 'labTestType'
                    },
                    {
                        association: 'labTestMethod'
                    },
                    {
                        association: 'labRequest',
                        required: true,
                        where: status ? {
                            status: (0, _labTest.hl7StatusToLabRequestStatus)(status)
                        } : null,
                        include: [
                            {
                                association: 'laboratory'
                            },
                            {
                                association: 'encounter',
                                required: true,
                                include: [
                                    {
                                        association: 'examiner'
                                    },
                                    {
                                        association: 'patient',
                                        where: {
                                            displayId
                                        }
                                    }
                                ]
                            }
                        ]
                    }
                ],
            bundleId: 'diagnostic-reports',
            toHL7: (labTest, { _include })=>{
                const includedResources = [];
                if (_include && _include.includes(_schema.DIAGNOSTIC_REPORT_INCLUDES.RESULT)) {
                    includedResources.push((0, _labTest.labTestToHL7Observation)(labTest));
                }
                if (_include && _include.includes(_schema.DIAGNOSTIC_REPORT_INCLUDES.DEVICE)) {
                    includedResources.push((0, _labTest.labTestToHL7Device)(labTest));
                }
                return {
                    mainResource: (0, _labTest.labTestToHL7DiagnosticReport)(labTest),
                    includedResources: includedResources.map((resource)=>({
                            resource
                        }))
                };
            }
        });
        res.send(payload);
    });
}
function immunizationHandler() {
    return (0, _expressasynchandler.default)(async (req, res)=>{
        const payload = await (0, _getHL7Payload.getHL7Payload)({
            req,
            querySchema: _schema.immunization.query,
            model: req.store.models.AdministeredVaccine,
            getWhere: ()=>({}),
            getInclude: _administeredVaccine.getAdministeredVaccineInclude,
            bundleId: 'immunizations',
            toHL7: (administeredVaccine)=>({
                    mainResource: (0, _administeredVaccine.administeredVaccineToHL7Immunization)(administeredVaccine)
                })
        });
        res.send(payload);
    });
}
function findSingleResource(modelName, include, toHL7Fn, where = {}, extraOptions = {}) {
    return (0, _expressasynchandler.default)(async (req, res)=>{
        const { models } = req.store;
        const { id } = req.params;
        const record = await models[modelName].findOne({
            where: {
                id,
                ...where
            },
            include,
            ...extraOptions
        });
        if (!record) {
            throw new _errors.NotFoundError(`Unable to find resource ${id}`);
        }
        const resource = await toHL7Fn(record, req);
        res.send(resource);
    });
}
function singlePatientHandler() {
    return findSingleResource('Patient', [
        {
            association: 'additionalData'
        }
    ], (patient, req)=>(0, _patient.patientToHL7Patient)(req, patient, patient.additionalData[0]), (0, _patient.getPatientWhereClause)(null, {}), {
        paranoid: false
    });
}
function singleDiagnosticReportHandler() {
    return findSingleResource('LabTest', [
        {
            association: 'labTestType'
        },
        {
            association: 'labTestMethod'
        },
        {
            association: 'labRequest',
            required: true,
            include: [
                {
                    association: 'laboratory'
                },
                {
                    association: 'encounter',
                    required: true,
                    include: [
                        {
                            association: 'examiner'
                        },
                        {
                            association: 'patient'
                        }
                    ]
                }
            ]
        }
    ], _labTest.labTestToHL7DiagnosticReport);
}
function singleImmunizationHandler() {
    return findSingleResource('AdministeredVaccine', (0, _administeredVaccine.getAdministeredVaccineInclude)(null, {}), _administeredVaccine.administeredVaccineToHL7Immunization);
}

//# sourceMappingURL=routeHandlers.js.map