"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
function _export(target, all) {
    for(var name in all)Object.defineProperty(target, name, {
        enumerable: true,
        get: all[name]
    });
}
_export(exports, {
    buildErrorHandler: function() {
        return buildErrorHandler;
    },
    defaultErrorHandler: function() {
        return defaultErrorHandler;
    }
});
const _errors = require("@tamanu/shared/errors");
const _logging = require("@tamanu/shared/services/logging");
const buildErrorHandler = (getResponse)=>(error, req, res, next)=>{
        const code = (0, _errors.getCodeForErrorName)(error.name);
        if (code >= 500) {
            _logging.log.error(`Error ${code}: `, error);
        } else {
            _logging.log.info(`Error ${code}: `, error);
        }
        // see https://expressjs.com/en/guide/error-handling.html#the-default-error-handler
        if (res.headersSent) {
            next(error);
            return;
        }
        res.status(code).send(getResponse(error));
    };
const defaultErrorHandler = buildErrorHandler((error)=>({
        error: {
            message: error.message,
            ...error
        }
    }));

//# sourceMappingURL=errorHandler.js.map