import React from 'react';
import { DataSection } from './DataSection';
import { DataItem } from './DataItem';
import { Col } from '../Layout';
import { formatShort } from '@tamanu/utils/dateTime';
import { useLanguageContext } from '../../pdf/languageContext';
export const SurveyResponseDetails = ({ surveyResponse })=>{
    const { getTranslation } = useLanguageContext();
    return /*#__PURE__*/ React.createElement(DataSection, {
        hideTopRule: true,
        hideBottomRule: true
    }, /*#__PURE__*/ React.createElement(Col, null, /*#__PURE__*/ React.createElement(DataItem, {
        label: getTranslation('general.localisedField.clinician.label.short', 'Clinician'),
        value: surveyResponse.submittedBy
    })), /*#__PURE__*/ React.createElement(Col, null, /*#__PURE__*/ React.createElement(DataItem, {
        label: getTranslation('pdf.surveyResponseDetails.dateOfSubmission', 'Date of submission'),
        value: formatShort(surveyResponse.endTime)
    })));
};

//# sourceMappingURL=SurveyResponseDetails.js.map