"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
function _export(target, all) {
    for(var name in all)Object.defineProperty(target, name, {
        enumerable: true,
        get: all[name]
    });
}
_export(exports, {
    DataImportError: function() {
        return DataImportError;
    },
    DataLoaderError: function() {
        return DataLoaderError;
    },
    DryRun: function() {
        return DryRun;
    },
    ForeignkeyResolutionError: function() {
        return ForeignkeyResolutionError;
    },
    ImporterMetadataError: function() {
        return ImporterMetadataError;
    },
    UpsertionError: function() {
        return UpsertionError;
    },
    ValidationError: function() {
        return ValidationError;
    },
    WorkSheetError: function() {
        return WorkSheetError;
    }
});
let DataImportError = class DataImportError extends Error {
    static get kind() {
        return 'DataImportError';
    }
    toJSON() {
        return {
            sheet: this.sheetName,
            row: this.rowNumber,
            kind: this.constructor.kind,
            message: this.previous.toString()
        };
    }
    constructor(sheetName, rowIndex, error){
        const rowNumber = rowIndex + 2; // correcting for zero-index and for header row
        let previous;
        if (typeof error === 'string') {
            previous = new Error(error);
        } else {
            previous = error;
        }
        if (previous instanceof Error) {
            super(`${previous.message} on ${sheetName} at row ${rowNumber}`);
        } else {
            throw new Error('DEV ERROR: pass either a string or Error error');
        }
        this.previous = previous;
        this.sheetName = sheetName;
        this.rowNumber = rowNumber;
    }
};
let DataLoaderError = class DataLoaderError extends DataImportError {
    static get kind() {
        return 'DataLoaderError';
    }
};
let ForeignkeyResolutionError = class ForeignkeyResolutionError extends DataImportError {
    static get kind() {
        return 'ForeignkeyResolutionError';
    }
};
let UpsertionError = class UpsertionError extends DataImportError {
    static get kind() {
        return 'UpsertionError';
    }
};
let ValidationError = class ValidationError extends DataImportError {
    static get kind() {
        return 'ValidationError';
    }
};
let WorkSheetError = class WorkSheetError extends DataImportError {
    static get kind() {
        return 'WorkSheetError';
    }
};
let ImporterMetadataError = class ImporterMetadataError extends DataImportError {
    static get kind() {
        return 'ImporterMetadataError';
    }
    constructor(error){
        super('metadata', -2, error);
    }
};
let DryRun = class DryRun extends Error {
    constructor(){
        super('Dry run: rollback');
    }
};

//# sourceMappingURL=errors.js.map