"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
function _export(target, all) {
    for(var name in all)Object.defineProperty(target, name, {
        enumerable: true,
        get: all[name]
    });
}
_export(exports, {
    canUploadAttachment: function() {
        return canUploadAttachment;
    },
    getFreeDiskSpace: function() {
        return getFreeDiskSpace;
    }
});
const _config = /*#__PURE__*/ _interop_require_default(require("config"));
const _checkdiskspace = /*#__PURE__*/ _interop_require_default(require("check-disk-space"));
const _logging = require("@tamanu/shared/services/logging");
function _interop_require_default(obj) {
    return obj && obj.__esModule ? obj : {
        default: obj
    };
}
const getFreeDiskSpace = async ()=>{
    try {
        const diskStats = await (0, _checkdiskspace.default)(_config.default.disk.diskPath);
        return diskStats.free;
    } catch (error) {
        _logging.log.error(`Unable to determine free disk space, got error: \n${error.message}`);
        return null;
    }
};
const canUploadAttachment = async (settings)=>{
    const gigabytesForUploadingDocuments = await settings.get('disk.freeSpaceRequired.gigabytesForUploadingDocuments');
    // Convert value in settings to bytes (prefer decimal over binary conversion)
    const freeSpaceRequired = Number.parseInt(gigabytesForUploadingDocuments, 10) * 1000000000;
    const freeDiskSpace = await getFreeDiskSpace();
    if (!freeDiskSpace || freeDiskSpace < freeSpaceRequired) {
        return false;
    }
    return true;
};

//# sourceMappingURL=getFreeDiskSpace.js.map