"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
function _export(target, all) {
    for(var name in all)Object.defineProperty(target, name, {
        enumerable: true,
        get: all[name]
    });
}
_export(exports, {
    down: function() {
        return down;
    },
    up: function() {
        return up;
    }
});
const _sequelize = require("sequelize");
async function up(query) {
    await query.addColumn('procedures', 'department_id', {
        type: _sequelize.DataTypes.STRING,
        allowNull: true,
        references: {
            model: 'departments',
            key: 'id'
        }
    });
    await query.addColumn('procedures', 'assistant_anaesthetist_id', {
        type: _sequelize.DataTypes.STRING,
        allowNull: true,
        references: {
            model: 'users',
            key: 'id'
        }
    });
    await query.addColumn('procedures', 'time_in', {
        type: _sequelize.DataTypes.DATETIMESTRING,
        allowNull: true
    });
    await query.addColumn('procedures', 'time_out', {
        type: _sequelize.DataTypes.DATETIMESTRING,
        allowNull: true
    });
    // Create junction table
    await query.createTable('procedure_survey_responses', {
        id: {
            type: _sequelize.DataTypes.UUID,
            defaultValue: _sequelize.DataTypes.UUIDV4,
            primaryKey: true
        },
        procedure_id: {
            type: _sequelize.DataTypes.STRING,
            allowNull: false,
            references: {
                model: 'procedures',
                key: 'id'
            },
            onDelete: 'CASCADE'
        },
        survey_response_id: {
            type: _sequelize.DataTypes.STRING,
            allowNull: false,
            references: {
                model: 'survey_responses',
                key: 'id'
            },
            onDelete: 'CASCADE'
        },
        created_at: {
            type: _sequelize.DataTypes.DATE,
            allowNull: false
        },
        updated_at: {
            type: _sequelize.DataTypes.DATE,
            allowNull: false
        },
        deleted_at: {
            type: _sequelize.DataTypes.DATE,
            allowNull: true
        }
    });
    // Add unique constraint to prevent duplicates
    await query.addConstraint('procedure_survey_responses', {
        fields: [
            'procedure_id',
            'survey_response_id'
        ],
        type: 'unique',
        name: 'unique_procedure_survey_response'
    });
}
async function down(query) {
    await query.dropTable('procedure_survey_responses');
    await query.removeColumn('procedures', 'time_out');
    await query.removeColumn('procedures', 'time_in');
    await query.removeColumn('procedures', 'assistant_anaesthetist_id');
    await query.removeColumn('procedures', 'department_id');
}

//# sourceMappingURL=1753315553170-procedure-enhancements.js.map