<!-- Note: This file is automatically generated from source code comments. Changes made in this file will be overridden. -->

# Function max

Compute the maximum value of a matrix or a  list with values.
In case of a multi dimensional array, the maximum of the flattened array
will be calculated. When `dim` is provided, the maximum over the selected
dimension will be calculated. Parameter `dim` is zero-based.


## Syntax

```js
math.max(a, b, c, ...)
math.max(A)
math.max(A, dim)
```

### Parameters

Parameter | Type | Description
--------- | ---- | -----------
`args` | ... * | A single matrix or or multiple scalar values

### Returns

Type | Description
---- | -----------
* | The maximum value


## Examples

```js
math.max(2, 1, 4, 3)                  // returns 4
math.max([2, 1, 4, 3])                // returns 4

// maximum over a specified dimension (zero-based)
math.max([[2, 5], [4, 3], [1, 7]], 0) // returns [4, 7]
math.max([[2, 5], [4, 3]], [1, 7], 1) // returns [5, 4, 7]

math.max(2.7, 7.1, -4.5, 2.0, 4.1)    // returns 7.1
math.min(2.7, 7.1, -4.5, 2.0, 4.1)    // returns -4.5
```


## See also

[mean](mean.md),
[median](median.md),
[min](min.md),
[prod](prod.md),
[std](std.md),
[sum](sum.md),
[variance](variance.md)
