"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
Object.defineProperty(exports, "ImagingResult", {
    enumerable: true,
    get: function() {
        return ImagingResult;
    }
});
const _sequelize = require("sequelize");
const _constants = require("@tamanu/constants");
const _errors = require("@tamanu/shared/errors");
const _dateTime = require("@tamanu/utils/dateTime");
const _Model = require("./Model");
const _buildEncounterLinkedSyncFilter = require("../sync/buildEncounterLinkedSyncFilter");
const _model = require("../types/model");
const _buildEncounterLinkedLookupFilter = require("../sync/buildEncounterLinkedLookupFilter");
let ImagingResult = class ImagingResult extends _Model.Model {
    static initModel(options) {
        super.init({
            id: {
                type: _sequelize.DataTypes.UUID,
                allowNull: false,
                primaryKey: true,
                defaultValue: _sequelize.Sequelize.fn('gen_random_uuid')
            },
            visibilityStatus: {
                type: _sequelize.DataTypes.STRING,
                allowNull: false,
                defaultValue: 'current'
            },
            completedAt: (0, _model.dateTimeType)('completedAt', {
                allowNull: false,
                defaultValue: _dateTime.getCurrentDateTimeString
            }),
            description: {
                type: _sequelize.DataTypes.TEXT
            },
            externalCode: _sequelize.DataTypes.TEXT,
            resultImageUrl: {
                type: _sequelize.DataTypes.TEXT,
                defaultValue: null,
                allowNull: true
            }
        }, {
            ...options,
            syncDirection: _constants.SYNC_DIRECTIONS.BIDIRECTIONAL,
            validate: {
                mustHaveImagingRequest () {
                    if (!this.imagingRequestId) {
                        throw new _errors.InvalidOperationError('An imaging result must be associated with an imaging request.');
                    }
                }
            }
        });
    }
    static getListReferenceAssociations() {
        return [
            'request',
            'completedBy'
        ];
    }
    static initRelations(models) {
        this.belongsTo(models.ImagingRequest, {
            foreignKey: 'imagingRequestId',
            as: 'request'
        });
        this.belongsTo(models.User, {
            foreignKey: 'completedById',
            as: 'completedBy'
        });
    }
    static buildPatientSyncFilter(patientCount, markedForSyncPatientsTable) {
        if (patientCount === 0) {
            return null;
        }
        return (0, _buildEncounterLinkedSyncFilter.buildEncounterLinkedSyncFilter)([
            this.tableName,
            'imaging_requests',
            'encounters'
        ], markedForSyncPatientsTable);
    }
    static async buildSyncLookupQueryDetails() {
        return {
            select: await (0, _buildEncounterLinkedLookupFilter.buildEncounterLinkedLookupSelect)(this),
            joins: (0, _buildEncounterLinkedLookupFilter.buildEncounterLinkedLookupJoins)(this, [
                'imaging_requests',
                'encounters'
            ])
        };
    }
};

//# sourceMappingURL=ImagingResult.js.map