"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
Object.defineProperty(exports, "attachmentRoutes", {
    enumerable: true,
    get: function() {
        return attachmentRoutes;
    }
});
const _express = /*#__PURE__*/ _interop_require_default(require("express"));
const _expressasynchandler = /*#__PURE__*/ _interop_require_default(require("express-async-handler"));
const _errors = require("@tamanu/shared/errors");
const _middleware = require("@tamanu/shared/permissions/middleware");
const _getFreeDiskSpace = require("./utils/getFreeDiskSpace");
function _interop_require_default(obj) {
    return obj && obj.__esModule ? obj : {
        default: obj
    };
}
const attachmentRoutes = _express.default.Router();
//TODO: Remove when permission check are implemented in all central server routes
attachmentRoutes.use(_middleware.ensurePermissionCheck);
attachmentRoutes.get('/:id', (0, _expressasynchandler.default)(async (req, res)=>{
    req.checkPermission('read', 'Attachment');
    const { query, params } = req;
    const { base64 } = query;
    const { id } = params;
    const attachment = await req.store.models.Attachment.findByPk(id);
    if (!attachment) {
        throw new _errors.ForbiddenError('You do not have permission to view this attachment.');
    }
    if (base64 === 'true') {
        res.send({
            data: Buffer.from(attachment.data).toString('base64')
        });
    } else {
        res.setHeader('Content-Type', attachment.type);
        res.setHeader('Content-Length', attachment.size);
        res.send(Buffer.from(attachment.data));
    }
}));
attachmentRoutes.post('/$', (0, _expressasynchandler.default)(async (req, res)=>{
    const { settings } = req;
    req.checkPermission('create', 'Attachment');
    const canUpload = await (0, _getFreeDiskSpace.canUploadAttachment)(settings);
    if (!canUpload) {
        throw new _errors.InsufficientStorageError('Document cannot be uploaded due to lack of storage space.');
    }
    const { Attachment } = req.store.models;
    const { type, size, data } = Attachment.sanitizeForDatabase(req.body);
    const attachment = await Attachment.create({
        type,
        size,
        data
    });
    // Send only the ID to be able to link it to metadata
    res.send({
        attachmentId: attachment.id
    });
}));

//# sourceMappingURL=attachment.js.map