"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
function _export(target, all) {
    for(var name in all)Object.defineProperty(target, name, {
        enumerable: true,
        get: all[name]
    });
}
_export(exports, {
    hl7PatientFields: function() {
        return hl7PatientFields;
    },
    sortableHL7PatientFields: function() {
        return sortableHL7PatientFields;
    }
});
const _sequelize = require("sequelize");
const _errors = require("@tamanu/shared/errors");
const _yup = /*#__PURE__*/ _interop_require_wildcard(require("yup"));
const _constants = require("@tamanu/constants");
const _hl7Parameters = require("./hl7Parameters");
const _identifier = require("./utils/identifier");
const _search = require("./utils/search");
function _getRequireWildcardCache(nodeInterop) {
    if (typeof WeakMap !== "function") return null;
    var cacheBabelInterop = new WeakMap();
    var cacheNodeInterop = new WeakMap();
    return (_getRequireWildcardCache = function(nodeInterop) {
        return nodeInterop ? cacheNodeInterop : cacheBabelInterop;
    })(nodeInterop);
}
function _interop_require_wildcard(obj, nodeInterop) {
    if (!nodeInterop && obj && obj.__esModule) {
        return obj;
    }
    if (obj === null || typeof obj !== "object" && typeof obj !== "function") {
        return {
            default: obj
        };
    }
    var cache = _getRequireWildcardCache(nodeInterop);
    if (cache && cache.has(obj)) {
        return cache.get(obj);
    }
    var newObj = {
        __proto__: null
    };
    var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor;
    for(var key in obj){
        if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) {
            var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null;
            if (desc && (desc.get || desc.set)) {
                Object.defineProperty(newObj, key, desc);
            } else {
                newObj[key] = obj[key];
            }
        }
    }
    newObj.default = obj;
    if (cache) {
        cache.set(obj, newObj);
    }
    return newObj;
}
const hl7PatientFields = {
    identifier: {
        parameterType: _hl7Parameters.hl7ParameterTypes.token,
        fieldName: 'displayId',
        columnName: 'display_id',
        supportedModifiers: [],
        validationSchema: _yup.string().test('is-correct-format-and-namespace', 'identifier must be in the format "<namespace>|<id>"', _identifier.isValidIdentifier),
        getValue: (value)=>{
            const [, identifier] = (0, _identifier.decodeIdentifier)(value);
            return identifier;
        }
    },
    given: {
        parameterType: _hl7Parameters.hl7ParameterTypes.string,
        fieldName: 'firstName',
        columnName: 'first_name',
        supportedModifiers: _hl7Parameters.stringTypeModifiers,
        validationSchema: _yup.string(),
        sortable: true
    },
    family: {
        parameterType: _hl7Parameters.hl7ParameterTypes.string,
        fieldName: 'lastName',
        columnName: 'last_name',
        supportedModifiers: _hl7Parameters.stringTypeModifiers,
        validationSchema: _yup.string(),
        sortable: true
    },
    gender: {
        parameterType: _hl7Parameters.hl7ParameterTypes.token,
        fieldName: 'sex',
        columnName: 'sex',
        supportedModifiers: [],
        validationSchema: _yup.string().oneOf([
            'male',
            'female',
            'other'
        ]),
        sortable: false
    },
    birthdate: {
        parameterType: _hl7Parameters.hl7ParameterTypes.date,
        fieldName: 'dateOfBirth',
        columnName: 'date_of_birth',
        supportedModifiers: [],
        validationSchema: _yup.string()// eslint-disable-next-line no-template-curly-in-string
        .test('is-valid-date', 'Invalid date/time format: ${value}', (value)=>{
            if (!value) return true;
            return (0, _search.isValidHl7Date)(value);
        }),
        sortable: true
    },
    // TODO: address should match a bunch of other fields
    address: {
        parameterType: _hl7Parameters.hl7ParameterTypes.string,
        fieldName: '$additionalData.city_town$',
        columnName: 'additionalData.city_town',
        supportedModifiers: _hl7Parameters.stringTypeModifiers,
        validationSchema: _yup.string(),
        sortable: true,
        sortArguments: [
            'additionalData',
            'cityTown'
        ]
    },
    'address-city': {
        parameterType: _hl7Parameters.hl7ParameterTypes.string,
        fieldName: '$additionalData.city_town$',
        columnName: 'additionalData.city_town',
        supportedModifiers: _hl7Parameters.stringTypeModifiers,
        validationSchema: _yup.string(),
        sortable: true,
        sortArguments: [
            'additionalData',
            'cityTown'
        ]
    },
    // TODO: telecom could also be email or other phones
    telecom: {
        parameterType: _hl7Parameters.hl7ParameterTypes.token,
        fieldName: '$additionalData.primary_contact_number$',
        columnName: 'additionalData.primary_contact_number',
        supportedModifiers: [],
        validationSchema: _yup.string(),
        sortable: true,
        sortArguments: [
            'additionalData',
            'primaryContactNumber'
        ]
    },
    deceased: {
        parameterType: _hl7Parameters.hl7ParameterTypes.token,
        fieldName: 'dateOfDeath',
        columnName: 'date_of_death',
        supportedModifiers: [],
        validationSchema: _yup.string().oneOf([
            'true',
            'false'
        ]),
        getValue: ()=>null,
        getOperator: (value)=>{
            if (value === 'true') {
                return _sequelize.Op.not;
            }
            if (value === 'false') {
                return _sequelize.Op.is;
            }
            throw new _errors.InvalidParameterError(`Invalid value for deceased parameter: ${value}`);
        }
    },
    active: {
        parameterType: _hl7Parameters.hl7ParameterTypes.token,
        fieldName: 'visibilityStatus',
        columnName: 'visibility_status',
        supportedModifiers: [],
        validationSchema: _yup.string().oneOf([
            'true',
            'false'
        ]),
        getValue: ()=>_constants.VISIBILITY_STATUSES.CURRENT,
        getOperator: (value)=>{
            if (value === 'true') {
                return _sequelize.Op.eq;
            }
            if (value === 'false') {
                return _sequelize.Op.ne;
            }
            throw new _errors.InvalidParameterError(`Invalid value for active parameter: ${value}`);
        }
    }
};
const sortableHL7PatientFields = Object.keys(hl7PatientFields).filter((field)=>hl7PatientFields[field].sortable);

//# sourceMappingURL=hl7PatientFields.js.map