"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
function _export(target, all) {
    for(var name in all)Object.defineProperty(target, name, {
        enumerable: true,
        get: all[name]
    });
}
_export(exports, {
    serveAll: function() {
        return serveAll;
    },
    startAllCommand: function() {
        return startAllCommand;
    }
});
const _config = /*#__PURE__*/ _interop_require_default(require("config"));
const _commander = require("commander");
const _logging = require("@tamanu/shared/services/logging");
const _constants = require("@tamanu/constants");
const _packagejson = /*#__PURE__*/ _interop_require_default(require("../../package.json"));
const _ApplicationContext = require("../ApplicationContext");
const _startApi = require("./startApi");
const _startFhirWorker = require("./startFhirWorker");
const _startTasks = require("./startTasks");
function _interop_require_default(obj) {
    return obj && obj.__esModule ? obj : {
        default: obj
    };
}
const serveAll = async ({ skipMigrationCheck })=>{
    _logging.log.info(`Starting Tamanu Central version ${_packagejson.default.version}`);
    if (_config.default.db.migrateOnStartup) {
        const { store } = await new _ApplicationContext.ApplicationContext().init({
            appType: _ApplicationContext.CENTRAL_SERVER_APP_TYPES.MIGRATE
        });
        await store.sequelize.migrate('up');
    }
    return Promise.race([
        (0, _startApi.startApi)({
            skipMigrationCheck
        }),
        (0, _startFhirWorker.startFhirWorker)({
            name: 'refresh',
            skipMigrationCheck,
            topics: [
                _constants.JOB_TOPICS.FHIR.REFRESH.ALL_FROM_UPSTREAM,
                _constants.JOB_TOPICS.FHIR.REFRESH.ENTIRE_RESOURCE,
                _constants.JOB_TOPICS.FHIR.REFRESH.FROM_UPSTREAM
            ].join(',')
        }),
        // Run the fhir.resolver topic in a separate worker, as currently it can take a long time and may block the queue (SAV-813)
        (0, _startFhirWorker.startFhirWorker)({
            name: 'resolver',
            skipMigrationCheck,
            topics: _constants.JOB_TOPICS.FHIR.RESOLVER
        }),
        (0, _startTasks.startTasks)({
            skipMigrationCheck
        })
    ]);
};
const startAllCommand = new _commander.Command('startAll').alias('serveAll') // deprecated
.description('Start the Tamanu Central servers and tasks runners').option('--skipMigrationCheck', 'skip the migration check on startup').action(serveAll);

//# sourceMappingURL=startAll.js.map