"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
function _export(target, all) {
    for(var name in all)Object.defineProperty(target, name, {
        enumerable: true,
        get: all[name]
    });
}
_export(exports, {
    migrateAppointments: function() {
        return migrateAppointments;
    },
    migrateAppointmentsToLocationGroupsCommand: function() {
        return migrateAppointmentsToLocationGroupsCommand;
    }
});
const _commander = require("commander");
const _sequelize = require("sequelize");
const _logging = require("@tamanu/shared/services/logging");
const _database = require("../database");
async function migrateAppointments() {
    _logging.log.info('Migrating appointments...');
    const store = await (0, _database.initDatabase)({
        testMode: false
    });
    const { Appointment } = store.models;
    try {
        let migrated = 0;
        const appointments = await Appointment.findAll({
            include: 'location',
            where: {
                locationGroupId: {
                    [_sequelize.Op.is]: null
                }
            }
        });
        await Promise.all(appointments.map(async (a)=>{
            const { location } = a;
            const { locationGroupId } = location;
            // Skip if there is no location group
            if (locationGroupId) {
                await a.update({
                    locationGroupId
                });
                migrated++;
            } else {
                _logging.log.warn(`The following location has no related location group: ${location.name}`);
            }
            return location;
        }));
        _logging.log.info(`Successfully migrated ${migrated} appointments`);
        process.exit(0);
    } catch (error) {
        _logging.log.info(`Command failed: ${error.stack}\n`);
        process.exit(1);
    }
}
const migrateAppointmentsToLocationGroupsCommand = new _commander.Command('migrateAppointmentsToLocationGroups').description('Migrates appointments from locations to location groups').action(migrateAppointments);

//# sourceMappingURL=migrateAppointmentsToLocationGroups.js.map