"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
Object.defineProperty(exports, "createEncounter", {
    enumerable: true,
    get: function() {
        return createEncounter;
    }
});
const _constants = require("@tamanu/constants");
const _utilities = require("@tamanu/database/demoData/utilities");
const _lodash = require("lodash");
const _index = require("../../fake/index.js");
const createEncounter = async ({ models, limit, patientId, departmentId, locationId, userId, referenceDataId, noteCount = _index.chance.integer({
    min: 1,
    max: 5
}), diagnosisCount = _index.chance.integer({
    min: 1,
    max: 5
}), isDischarged = _index.chance.bool() })=>{
    const { Encounter, EncounterHistory, Note, Discharge, EncounterDiagnosis } = models;
    const encounter = await Encounter.create((0, _index.fake)(Encounter, {
        patientId: patientId || await (0, _utilities.randomRecordId)(models, 'Patient'),
        departmentId: departmentId || await (0, _utilities.randomRecordId)(models, 'Department'),
        locationId: locationId || await (0, _utilities.randomRecordId)(models, 'Location'),
        examinerId: userId || await (0, _utilities.randomRecordId)(models, 'User'),
        startDate: '2023-12-21T04:59:51.851Z'
    }));
    await EncounterHistory.create((0, _index.fake)(EncounterHistory, {
        examinerId: userId || await (0, _utilities.randomRecordId)(models, 'User'),
        encounterId: encounter.id,
        departmentId: departmentId || await (0, _utilities.randomRecordId)(models, 'Department'),
        locationId: locationId || await (0, _utilities.randomRecordId)(models, 'Location')
    }));
    await Promise.all((0, _lodash.times)(diagnosisCount, ()=>limit(async ()=>{
            await EncounterDiagnosis.create((0, _index.fake)(EncounterDiagnosis, {
                diagnosisId: referenceDataId || await (0, _utilities.randomRecordId)(models, 'ReferenceData'),
                encounterId: encounter.id
            }));
        })));
    await Promise.all((0, _lodash.times)(noteCount, ()=>limit(async ()=>{
            await Note.create((0, _index.fake)(Note, {
                recordType: _constants.NOTE_RECORD_TYPES.ENCOUNTER,
                recordId: encounter.id,
                authorId: userId || await (0, _utilities.randomRecordId)(models, 'User')
            }));
        })));
    if (isDischarged) {
        await Discharge.create((0, _index.fake)(Discharge, {
            encounterId: encounter.id,
            dischargerId: userId || await (0, _utilities.randomRecordId)(models, 'User')
        }));
    }
    return {
        encounter
    };
};

//# sourceMappingURL=encounter.js.map