"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
function _export(target, all) {
    for(var name in all)Object.defineProperty(target, name, {
        enumerable: true,
        get: all[name]
    });
}
_export(exports, {
    down: function() {
        return down;
    },
    up: function() {
        return up;
    }
});
async function up(query) {
    await query.sequelize.query(`
    CREATE OR REPLACE FUNCTION public.set_updated_at()
     RETURNS trigger
     LANGUAGE plpgsql
    AS $function$
    BEGIN
        IF (to_jsonb(NEW) ? 'updated_at') THEN
            IF (
                (to_jsonb(NEW) - 'updated_at') IS DISTINCT FROM (to_jsonb(OLD) - 'updated_at')
                AND
                (to_jsonb(NEW)->'updated_at') IS NOT DISTINCT FROM (to_jsonb(OLD)->'updated_at')
            ) THEN
                NEW.updated_at := current_timestamp;
            END IF;
        END IF;
        RETURN NEW;
    END;
    $function$
  `);
}
async function down(query) {
    await query.sequelize.query('DROP FUNCTION IF EXISTS public.set_updated_at() CASCADE');
}

//# sourceMappingURL=1750646475712-automaticUpdatedAt.js.map