"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
function _export(target, all) {
    for(var name in all)Object.defineProperty(target, name, {
        enumerable: true,
        get: all[name]
    });
}
_export(exports, {
    down: function() {
        return down;
    },
    up: function() {
        return up;
    }
});
const _config = /*#__PURE__*/ _interop_require_default(require("config"));
const _sequelize = require("sequelize");
const _selectFacilityIds = require("@tamanu/utils/selectFacilityIds");
function _interop_require_default(obj) {
    return obj && obj.__esModule ? obj : {
        default: obj
    };
}
const SCHEMA = 'fhir';
const TABLES = [
    'patients',
    'diagnostic_reports',
    'immunizations',
    'service_requests'
];
async function up(query) {
    // Central only
    const isFacilityServer = !!(0, _selectFacilityIds.selectFacilityIds)(_config.default);
    if (isFacilityServer) return;
    const COUNTRY_TIMEZONE = _config.default?.countryTimeZone;
    if (!COUNTRY_TIMEZONE) {
        throw Error('A countryTimeZone must be configured in local.json5 for this migration to run.');
    }
    await query.sequelize.query(`SET TIME ZONE '${COUNTRY_TIMEZONE}'`);
    for (const tableName of TABLES){
        await query.changeColumn({
            schema: SCHEMA,
            tableName
        }, 'last_updated', {
            type: 'timestamp',
            defaultValue: _sequelize.Sequelize.fn('NOW'),
            allowNull: false
        });
    }
}
async function down(query) {
    // Central only
    const isFacilityServer = !!(0, _selectFacilityIds.selectFacilityIds)(_config.default);
    if (isFacilityServer) return;
    const COUNTRY_TIMEZONE = _config.default?.countryTimeZone;
    if (!COUNTRY_TIMEZONE) {
        throw Error('A countryTimeZone must be configured in local.json5 for this migration to run.');
    }
    await query.sequelize.query(`SET TIME ZONE '${COUNTRY_TIMEZONE}'`);
    for (const tableName of TABLES){
        await query.changeColumn({
            schema: SCHEMA,
            tableName
        }, 'last_updated', {
            type: 'timestamptz',
            defaultValue: _sequelize.Sequelize.fn('NOW'),
            allowNull: false
        });
    }
}

//# sourceMappingURL=1683620093808-fhirLastUpdatedToTimestampWithoutTimeZone.js.map