"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
function _export(target, all) {
    for(var name in all)Object.defineProperty(target, name, {
        enumerable: true,
        get: all[name]
    });
}
_export(exports, {
    Deleted: function() {
        return Deleted;
    },
    Exception: function() {
        return Exception;
    },
    FhirError: function() {
        return FhirError;
    },
    Invalid: function() {
        return Invalid;
    },
    NotFound: function() {
        return NotFound;
    },
    Processing: function() {
        return Processing;
    },
    Unsupported: function() {
        return Unsupported;
    }
});
const _constants = require("@tamanu/constants");
let FhirError = class FhirError extends Error {
    constructor(message, { status = 500, severity = _constants.FHIR_ISSUE_SEVERITY.ERROR, code = _constants.FHIR_ISSUE_TYPE.TRANSIENT._, diagnostics = null, expression = undefined } = {}){
        super(message);
        this.status = status;
        this.severity = severity;
        this.code = code;
        this.diagnostics = diagnostics;
        this.expression = expression;
    }
    asFhir() {
        return {
            severity: this.severity,
            code: this.code,
            diagnostics: this.diagnostics || this.stack,
            expression: this.expression,
            details: {
                text: this.message
            }
        };
    }
};
let Exception = class Exception extends FhirError {
    constructor(message, options = {}){
        super(message, {
            status: 500,
            code: _constants.FHIR_ISSUE_TYPE.TRANSIENT.EXCEPTION,
            ...options
        });
    }
};
let Invalid = class Invalid extends FhirError {
    constructor(message, options = {}){
        super(message, {
            status: 400,
            code: _constants.FHIR_ISSUE_TYPE.INVALID._,
            ...options
        });
    }
};
let Processing = class Processing extends FhirError {
    constructor(message, options = {}){
        super(message, {
            status: 500,
            code: _constants.FHIR_ISSUE_TYPE.PROCESSING._,
            ...options
        });
    }
};
let Unsupported = class Unsupported extends Processing {
    constructor(message, options = {}){
        super(message, {
            status: 501,
            code: _constants.FHIR_ISSUE_TYPE.PROCESSING.NOT_SUPPORTED,
            ...options
        });
    }
};
let NotFound = class NotFound extends Processing {
    constructor(message, options = {}){
        super(message, {
            status: 404,
            code: _constants.FHIR_ISSUE_TYPE.PROCESSING.NOT_FOUND._,
            ...options
        });
    }
};
let Deleted = class Deleted extends Processing {
    constructor(message, options = {}){
        super(message, {
            status: 410,
            code: _constants.FHIR_ISSUE_TYPE.PROCESSING.NOT_FOUND.DELETED,
            ...options
        });
    }
};

//# sourceMappingURL=errors.js.map