"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
Object.defineProperty(exports, "ChangeLog", {
    enumerable: true,
    get: function() {
        return ChangeLog;
    }
});
const _sequelize = require("sequelize");
const _constants = require("@tamanu/constants");
const _Model = require("./Model");
let ChangeLog = class ChangeLog extends _Model.Model {
    static initModel({ primaryKey, ...options }) {
        super.init({
            id: primaryKey,
            tableOid: {
                type: _sequelize.DataTypes.INTEGER,
                allowNull: false
            },
            tableSchema: {
                type: _sequelize.DataTypes.TEXT,
                allowNull: false
            },
            tableName: {
                type: _sequelize.DataTypes.TEXT,
                allowNull: false
            },
            loggedAt: {
                type: _sequelize.DataTypes.DATE,
                allowNull: false
            },
            updatedByUserId: {
                type: _sequelize.DataTypes.TEXT,
                allowNull: false
            },
            recordId: {
                type: _sequelize.DataTypes.TEXT,
                allowNull: false
            },
            recordCreatedAt: {
                type: _sequelize.DataTypes.DATE,
                allowNull: false
            },
            recordUpdatedAt: {
                type: _sequelize.DataTypes.DATE,
                allowNull: false
            },
            recordDeletedAt: {
                type: _sequelize.DataTypes.DATE,
                allowNull: true
            },
            recordData: {
                type: _sequelize.DataTypes.JSONB,
                allowNull: false
            },
            deviceId: {
                type: _sequelize.DataTypes.TEXT,
                allowNull: false
            },
            version: {
                type: _sequelize.DataTypes.TEXT,
                allowNull: false
            },
            reason: {
                type: _sequelize.DataTypes.TEXT,
                allowNull: true
            }
        }, {
            ...options,
            tableName: 'changes',
            syncDirection: _constants.SYNC_DIRECTIONS.DO_NOT_SYNC,
            schema: 'logs',
            timestamps: false
        });
    }
    static initRelations(models) {
        this.belongsTo(models.User, {
            foreignKey: 'updatedByUserId',
            as: 'updatedByUser'
        });
    }
};

//# sourceMappingURL=ChangeLog.js.map