"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
Object.defineProperty(exports, "SyncLookupTick", {
    enumerable: true,
    get: function() {
        return SyncLookupTick;
    }
});
const _sequelize = require("sequelize");
const _constants = require("@tamanu/constants");
const _Model = require("./Model");
let SyncLookupTick = class SyncLookupTick extends _Model.Model {
    // eslint-disable-next-line @typescript-eslint/no-unused-vars
    static initModel({ primaryKey, ...options }) {
        super.init({
            id: {
                // Sequelize always requires an id column
                // so this is to enforce using lookup_end_tick as the id.
                // even though we don't really need an id in this table.
                // We don't use the value of lookup_end_tick in id
                // just so that it is clear about the type of tick that it is storing.
                type: `BIGINT GENERATED ALWAYS AS ("lookup_end_tick")`,
                set () {
                // any sets of the convenience generated "id" field can be ignored, so do nothing here
                }
            },
            sourceStartTick: {
                type: _sequelize.DataTypes.BIGINT,
                allowNull: false
            },
            lookupEndTick: {
                type: _sequelize.DataTypes.BIGINT,
                allowNull: false,
                primaryKey: true
            }
        }, {
            ...options,
            syncDirection: _constants.SYNC_DIRECTIONS.DO_NOT_SYNC,
            timestamps: false
        });
    }
};

//# sourceMappingURL=SyncLookupTick.js.map