import { FhirReference, FhirIdentifier, FhirAnnotation, FhirCodeableConcept, FhirDosageInstruction } from '@tamanu/shared/services/fhirTypes';
import type { Models } from '../../../types/model';
import type { PharmacyOrderPrescription } from '../../../models';
export declare function getValues(upstream: PharmacyOrderPrescription, models: Models): Promise<{
    lastUpdated: Date;
    identifier: FhirIdentifier[];
    status: string;
    intent: string;
    category: FhirCodeableConcept | null;
    groupIdentifier: FhirIdentifier[];
    medication: FhirCodeableConcept;
    authoredOn: Date;
    dosageInstruction: FhirDosageInstruction | null;
    dispenseRequest: {
        quantity: number | undefined;
        numberOfRepeatsAllowed: number | undefined;
    };
    recorder: FhirReference;
    requester: FhirReference;
    subject: FhirReference;
    encounter: FhirReference;
    note: FhirAnnotation[] | null;
    resolved: boolean;
}>;
//# sourceMappingURL=getValues.d.ts.map