"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
function _export(target, all) {
    for(var name in all)Object.defineProperty(target, name, {
        enumerable: true,
        get: all[name]
    });
}
_export(exports, {
    down: function() {
        return down;
    },
    up: function() {
        return up;
    }
});
const _sequelize = require("sequelize");
const _config = /*#__PURE__*/ _interop_require_default(require("config"));
function _interop_require_default(obj) {
    return obj && obj.__esModule ? obj : {
        default: obj
    };
}
const ISO9075_DATE_TIME_FMT = 'YYYY-MM-DD HH24:MI:SS';
const MIGRATIONS = [
    {
        TABLE: 'document_metadata',
        FIELD: 'document_created_at'
    },
    {
        TABLE: 'document_metadata',
        FIELD: 'document_uploaded_at'
    }
];
const alterSchemaOnly = async (query, table, field)=>{
    // Change column types from of original columns from date to string
    return query.sequelize.query(`
      ALTER TABLE ${table}
      ALTER COLUMN ${field} TYPE date_time_string;
    `);
};
const alterSchemaAndBackUpLegacyData = async (query, table, field)=>{
    const COUNTRY_TIMEZONE = _config.default?.countryTimeZone;
    if (!COUNTRY_TIMEZONE) {
        throw Error('A countryTimeZone must be configured in local.json5 for this migration to run.');
    }
    // Copy data to legacy columns for backup
    await query.sequelize.query(`
      UPDATE ${table}
      SET
          ${field}_legacy = ${field};
  `);
    // Change column types from of original columns from date to string & convert data to string
    return query.sequelize.query(`
    ALTER TABLE ${table}
    ALTER COLUMN ${field} TYPE date_time_string
    USING TO_CHAR(${field}::TIMESTAMPTZ AT TIME ZONE '${COUNTRY_TIMEZONE}', '${ISO9075_DATE_TIME_FMT}');
  `);
};
async function up(query) {
    for (const migration of MIGRATIONS){
        // Create legacy columns
        await query.addColumn(migration.TABLE, `${migration.FIELD}_legacy`, {
            type: _sequelize.DataTypes.DATE
        });
        // Check for legacy data
        // Check if there is any legacy data in the system
        // For example, newly deployed instances of tamanu won't have legacy data
        const legacyDataCount = await query.sequelize.query(`SELECT COUNT(*) FROM ${migration.TABLE} WHERE ${migration.FIELD}_legacy IS NOT NULL;`, {
            type: _sequelize.QueryTypes.SELECT
        });
        // If there is no legacy column data, then we don't need to run the data migration or check
        // for the timezone in the config
        if (legacyDataCount === 0) {
            await alterSchemaOnly(query, migration.TABLE, migration.FIELD);
        } else {
            await alterSchemaAndBackUpLegacyData(query, migration.TABLE, migration.FIELD);
        }
    }
}
async function down(query) {
    for (const migration of MIGRATIONS){
        await query.sequelize.query(`
      ALTER TABLE ${migration.TABLE}
      ALTER COLUMN ${migration.FIELD} TYPE ${migration.LEGACY_TYPE?.postgres || 'timestamp with time zone'} USING ${migration.FIELD}_legacy;
    `);
        await query.removeColumn(migration.TABLE, `${migration.FIELD}_legacy`);
    }
}

//# sourceMappingURL=1679533922049-updateDocumentMetadataDateFields.js.map