"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
function _export(target, all) {
    for(var name in all)Object.defineProperty(target, name, {
        enumerable: true,
        get: all[name]
    });
}
_export(exports, {
    down: function() {
        return down;
    },
    up: function() {
        return up;
    }
});
const _sequelize = /*#__PURE__*/ _interop_require_wildcard(require("sequelize"));
function _getRequireWildcardCache(nodeInterop) {
    if (typeof WeakMap !== "function") return null;
    var cacheBabelInterop = new WeakMap();
    var cacheNodeInterop = new WeakMap();
    return (_getRequireWildcardCache = function(nodeInterop) {
        return nodeInterop ? cacheNodeInterop : cacheBabelInterop;
    })(nodeInterop);
}
function _interop_require_wildcard(obj, nodeInterop) {
    if (!nodeInterop && obj && obj.__esModule) {
        return obj;
    }
    if (obj === null || typeof obj !== "object" && typeof obj !== "function") {
        return {
            default: obj
        };
    }
    var cache = _getRequireWildcardCache(nodeInterop);
    if (cache && cache.has(obj)) {
        return cache.get(obj);
    }
    var newObj = {
        __proto__: null
    };
    var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor;
    for(var key in obj){
        if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) {
            var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null;
            if (desc && (desc.get || desc.set)) {
                Object.defineProperty(newObj, key, desc);
            } else {
                newObj[key] = obj[key];
            }
        }
    }
    newObj.default = obj;
    if (cache) {
        cache.set(obj, newObj);
    }
    return newObj;
}
const TABLE = {
    schema: 'fhir',
    tableName: 'medication_requests'
};
async function up(query) {
    await query.createTable(TABLE, {
        id: {
            type: _sequelize.DataTypes.UUID,
            allowNull: false,
            primaryKey: true,
            defaultValue: _sequelize.default.fn('uuid_generate_v4')
        },
        version_id: {
            type: _sequelize.DataTypes.UUID,
            allowNull: false,
            defaultValue: _sequelize.default.fn('uuid_generate_v4')
        },
        upstream_id: {
            type: _sequelize.DataTypes.UUID,
            allowNull: false,
            unique: true
        },
        last_updated: {
            type: _sequelize.DataTypes.DATE,
            defaultValue: _sequelize.default.NOW,
            allowNull: false
        },
        identifier: {
            type: _sequelize.DataTypes.JSONB,
            allowNull: true
        },
        status: {
            type: _sequelize.DataTypes.TEXT,
            allowNull: false
        },
        intent: {
            type: _sequelize.DataTypes.TEXT,
            allowNull: false
        },
        group_identifier: {
            type: _sequelize.DataTypes.JSONB,
            allowNull: true
        },
        subject: {
            type: _sequelize.DataTypes.JSONB,
            allowNull: true
        },
        encounter: {
            type: _sequelize.DataTypes.JSONB,
            allowNull: true
        },
        medication: {
            type: _sequelize.DataTypes.JSONB,
            allowNull: true
        },
        authored_on: {
            type: _sequelize.DataTypes.DATE,
            allowNull: true
        },
        requester: {
            type: _sequelize.DataTypes.JSONB,
            allowNull: true
        },
        recorder: {
            type: _sequelize.DataTypes.JSONB,
            allowNull: true
        },
        note: {
            type: _sequelize.DataTypes.JSONB,
            allowNull: true
        },
        dosage_instruction: {
            type: _sequelize.DataTypes.JSONB,
            allowNull: true
        },
        dispense_request: {
            type: _sequelize.DataTypes.JSONB,
            allowNull: true
        },
        resolved: {
            type: _sequelize.DataTypes.BOOLEAN,
            allowNull: false,
            defaultValue: false
        },
        is_live: {
            type: _sequelize.DataTypes.BOOLEAN,
            allowNull: false,
            defaultValue: true
        }
    });
    await query.addIndex(TABLE, [
        'id',
        'version_id'
    ]);
    await query.addIndex(TABLE, [
        'upstream_id'
    ]);
    await query.sequelize.query(`
    CREATE TRIGGER versioning BEFORE UPDATE ON fhir.${TABLE.tableName}
    FOR EACH ROW EXECUTE FUNCTION fhir.trigger_versioning()
  `);
}
async function down(query) {
    await query.dropTable(TABLE);
}

//# sourceMappingURL=1752563741574-CreateFhirMedicationRequestTable.js.map