import { Model } from './Model';
import { buildPatientSyncFilterViaPatientId } from '../sync/buildPatientSyncFilterViaPatientId';
import type { InitOptions, Models } from '../types/model';
import type { Prescription } from './Prescription';
export declare class PatientOngoingPrescription extends Model {
    id: string;
    patientId?: string;
    prescriptionId?: string;
    static initModel({ primaryKey, ...options }: InitOptions): void;
    static initRelations(models: Models): void;
    static buildSyncLookupQueryDetails(): Promise<{
        select: string;
        joins: string;
    }>;
    static buildPatientSyncFilter: typeof buildPatientSyncFilterViaPatientId;
    static findPatientOngoingPrescriptionWithSameDetails(patientId: string, prescription: Prescription): Promise<PatientOngoingPrescription | null>;
}
//# sourceMappingURL=PatientOngoingPrescription.d.ts.map