"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
Object.defineProperty(exports, "validatePatientProgramRegistrationRequest", {
    enumerable: true,
    get: function() {
        return validatePatientProgramRegistrationRequest;
    }
});
const _ability = require("@casl/ability");
const _errors = require("@tamanu/shared/errors");
const validatePatientProgramRegistrationRequest = async (req, patientId, programRegistryId)=>{
    const { checkPermission, models } = req;
    checkPermission('read', 'Patient');
    checkPermission('read', (0, _ability.subject)('ProgramRegistry', {
        id: programRegistryId
    }));
    const patient = await models.Patient.findByPk(patientId);
    if (!patient) throw new _errors.NotFoundError();
    const programRegistry = await models.ProgramRegistry.findByPk(programRegistryId);
    if (!programRegistry) throw new _errors.NotFoundError();
    return true;
};

//# sourceMappingURL=utils.js.map