import { IMAGING_TYPES_VALUES } from '@tamanu/constants';
import { Model } from './Model';
import { type InitOptions, type Models } from '../types/model';
import type { ImagingRequestArea } from './ImagingRequestArea';
import type { Encounter } from './Encounter';
import type { User } from './User';
import type { Note } from './Note';
import type { Location } from './Location';
import type { LocationGroup } from './LocationGroup';
declare const ALL_IMAGING_REQUEST_STATUS_TYPES: string[];
export declare class ImagingRequest extends Model {
    id: string;
    displayId: string;
    imagingType: (typeof IMAGING_TYPES_VALUES)[number];
    reasonForCancellation?: string;
    status: (typeof ALL_IMAGING_REQUEST_STATUS_TYPES)[number];
    requestedDate: string;
    legacyResults: string;
    priority?: string;
    encounterId?: string;
    requestedById: string;
    completedById?: string;
    locationGroupId?: string;
    locationId?: string;
    areas: ImagingRequestArea[];
    encounter?: Encounter;
    requestedBy?: User;
    notes: Note[];
    location?: Location;
    locationGroup?: LocationGroup;
    static initModel(options: InitOptions, models: Models): void;
    extractNotes(): Promise<{
        note: any;
        areaNote: any;
        notes: Note[];
    }>;
    static getListReferenceAssociations(): string[];
    static initRelations(models: Models): void;
    static buildPatientSyncFilter(patientCount: number, markedForSyncPatientsTable: string): string | null;
    static buildSyncLookupQueryDetails(): Promise<{
        select: string;
        joins: string;
    }>;
}
export {};
//# sourceMappingURL=ImagingRequest.d.ts.map