/*
Returns the first Note (Sequelize model instance) with the specified noteType, or undefined.

notes: Array<SequelizeModel>
noteType: string
*/ "use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
function _export(target, all) {
    for(var name in all)Object.defineProperty(target, name, {
        enumerable: true,
        get: all[name]
    });
}
_export(exports, {
    getNoteWithType: function() {
        return getNoteWithType;
    },
    getNotesWithType: function() {
        return getNotesWithType;
    }
});
const getNoteWithType = (notes, noteType)=>{
    return getNotesWithType(notes, noteType)[0];
};
const getNotesWithType = (notes, noteType)=>{
    return notes.filter((note)=>note.noteType === noteType);
};

//# sourceMappingURL=notes.js.map