"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
Object.defineProperty(exports, "default", {
    enumerable: true,
    get: function() {
        return _default;
    }
});
const Sequelize = require('sequelize');
const _default = {
    up: async (query)=>{
        await query.createTable('departments', {
            id: {
                type: Sequelize.STRING,
                defaultValue: Sequelize.UUIDV4,
                allowNull: false,
                primaryKey: true
            },
            created_at: {
                type: Sequelize.DATE,
                defaultValue: Sequelize.NOW
            },
            updated_at: {
                type: Sequelize.DATE,
                defaultValue: Sequelize.NOW
            },
            deleted_at: {
                type: Sequelize.DATE,
                defaultValue: Sequelize.NOW
            },
            code: {
                type: Sequelize.STRING,
                allowNull: false
            },
            name: {
                type: Sequelize.STRING,
                allowNull: false
            },
            facility_id: {
                type: Sequelize.STRING,
                references: {
                    model: 'facilities',
                    key: 'id'
                }
            }
        }, {
            indexes: [
                {
                    unique: true,
                    fields: [
                        'code'
                    ]
                },
                {
                    unique: true,
                    fields: [
                        'name'
                    ]
                }
            ]
        });
    },
    down: async (query)=>{
        await query.dropTable('departments');
    }
};

//# sourceMappingURL=043_addDepartmentsTable.js.map