"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
Object.defineProperty(exports, "UserExporter", {
    enumerable: true,
    get: function() {
        return UserExporter;
    }
});
const _ModelExporter = require("./ModelExporter");
let UserExporter = class UserExporter extends _ModelExporter.ModelExporter {
    async getData() {
        const modelName = 'User';
        const users = await this.models[modelName].findAll({
            include: this.models.User.getFullReferenceAssociations()
        });
        return users.map((user)=>({
                ...user.dataValues,
                designations: user.designations.map((it)=>it.referenceData.id).join(', '),
                allowedFacilities: user.facilities.map(({ id })=>id).join(',')
            }));
    }
    customHiddenColumns() {
        return [
            'type',
            'facilities'
        ];
    }
};

//# sourceMappingURL=UserExporter.js.map