"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
function _export(target, all) {
    for(var name in all)Object.defineProperty(target, name, {
        enumerable: true,
        get: all[name]
    });
}
_export(exports, {
    createZipFromFile: function() {
        return createZipFromFile;
    },
    createZippedSpreadsheet: function() {
        return createZippedSpreadsheet;
    },
    removeFile: function() {
        return removeFile;
    },
    writeToSpreadsheet: function() {
        return writeToSpreadsheet;
    }
});
const _fs = /*#__PURE__*/ _interop_require_default(require("fs"));
const _path = /*#__PURE__*/ _interop_require_default(require("path"));
const _xlsx = /*#__PURE__*/ _interop_require_wildcard(require("xlsx"));
const _jszip = /*#__PURE__*/ _interop_require_default(require("jszip"));
const _utils = require("@tamanu/shared/utils");
function _interop_require_default(obj) {
    return obj && obj.__esModule ? obj : {
        default: obj
    };
}
function _getRequireWildcardCache(nodeInterop) {
    if (typeof WeakMap !== "function") return null;
    var cacheBabelInterop = new WeakMap();
    var cacheNodeInterop = new WeakMap();
    return (_getRequireWildcardCache = function(nodeInterop) {
        return nodeInterop ? cacheNodeInterop : cacheBabelInterop;
    })(nodeInterop);
}
function _interop_require_wildcard(obj, nodeInterop) {
    if (!nodeInterop && obj && obj.__esModule) {
        return obj;
    }
    if (obj === null || typeof obj !== "object" && typeof obj !== "function") {
        return {
            default: obj
        };
    }
    var cache = _getRequireWildcardCache(nodeInterop);
    if (cache && cache.has(obj)) {
        return cache.get(obj);
    }
    var newObj = {
        __proto__: null
    };
    var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor;
    for(var key in obj){
        if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) {
            var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null;
            if (desc && (desc.get || desc.set)) {
                Object.defineProperty(newObj, key, desc);
            } else {
                newObj[key] = obj[key];
            }
        }
    }
    newObj.default = obj;
    if (cache) {
        cache.set(obj, newObj);
    }
    return newObj;
}
function removeFile(filePath) {
    return new Promise((resolve)=>{
        _fs.default.unlink(filePath, (err)=>{
            if (err) {
                resolve([
                    undefined,
                    err
                ]);
            } else {
                resolve([]);
            }
        });
    });
}
const stringifyIfNonDateObject = (val)=>typeof val === 'object' && !(val instanceof Date) && val !== null ? JSON.stringify(val) : val;
async function writeToSpreadsheet({ data, metadata }, filePath, bookType) {
    const book = _xlsx.utils.book_new();
    const metadataSheet = _xlsx.utils.aoa_to_sheet(metadata);
    metadataSheet['!cols'] = [
        {
            wch: 30
        },
        {
            wch: 30
        }
    ];
    const stringifiedData = data.map((row)=>row.map(stringifyIfNonDateObject));
    const sheet = _xlsx.utils.aoa_to_sheet(stringifiedData);
    // For csv bookTypes, only the first sheet will be exported
    _xlsx.utils.book_append_sheet(book, sheet, 'report');
    _xlsx.utils.book_append_sheet(book, metadataSheet, 'metadata');
    return new Promise((resolve, reject)=>{
        _xlsx.writeFileAsync(filePath, book, {
            bookType,
            type: 'buffer'
        }, (err)=>{
            if (err) {
                reject(err);
            } else {
                resolve(filePath);
            }
        });
    });
}
async function createZipFromFile(fileName, filePath, zipFilePath) {
    const encoding = 'base64';
    const fileContent = await _fs.default.promises.readFile(filePath);
    const zip = new _jszip.default();
    // write the file into zip
    zip.file(fileName, fileContent);
    const zipContent = await zip.generateAsync({
        type: encoding,
        compression: 'DEFLATE',
        compressionOptions: {
            level: 9
        }
    });
    await _fs.default.promises.writeFile(zipFilePath, zipContent, {
        encoding
    });
}
async function createZippedSpreadsheet(reportName, data, bookType = 'xlsx') {
    const folder = await (0, _utils.tmpdir)();
    const excelFileName = `${reportName}.${bookType}`;
    const excelFilePath = _path.default.join(folder, excelFileName);
    const zipFilePath = _path.default.join(folder, `${reportName}.zip`);
    await writeToSpreadsheet(data, excelFilePath, bookType);
    await createZipFromFile(excelFileName, excelFilePath, zipFilePath);
    await removeFile(excelFilePath);
    return zipFilePath;
}

//# sourceMappingURL=files.js.map