import { Model } from './Model';
import type { InitOptions, Models } from '../types/model';
export declare class CertifiableVaccine extends Model {
    id: string;
    icd11DrugCode: string;
    icd11DiseaseCode: string;
    vaccineCode: string;
    targetCode?: string;
    euProductCode?: string;
    maximumDosage: number;
    vaccineId?: string;
    manufacturerId?: string;
    static initModel({ primaryKey, ...options }: InitOptions): void;
    static getListReferenceAssociations(): string[];
    static initRelations(models: Models): void;
    static allVaccineIds(euDccOnly?: boolean): Promise<(string | undefined)[]>;
    usableForEuDcc(): boolean;
    static buildSyncFilter(): null;
    static buildSyncLookupQueryDetails(): Promise<null>;
}
//# sourceMappingURL=CertifiableVaccine.d.ts.map