import { DataTypes } from 'sequelize';
import { SYNC_DIRECTIONS } from '@tamanu/constants';
import { Model } from './Model';
export class ChangeLog extends Model {
    static initModel({ primaryKey, ...options }) {
        super.init({
            id: primaryKey,
            tableOid: {
                type: DataTypes.INTEGER,
                allowNull: false
            },
            tableSchema: {
                type: DataTypes.TEXT,
                allowNull: false
            },
            tableName: {
                type: DataTypes.TEXT,
                allowNull: false
            },
            loggedAt: {
                type: DataTypes.DATE,
                allowNull: false
            },
            updatedByUserId: {
                type: DataTypes.TEXT,
                allowNull: false
            },
            recordId: {
                type: DataTypes.TEXT,
                allowNull: false
            },
            recordCreatedAt: {
                type: DataTypes.DATE,
                allowNull: false
            },
            recordUpdatedAt: {
                type: DataTypes.DATE,
                allowNull: false
            },
            recordDeletedAt: {
                type: DataTypes.DATE,
                allowNull: true
            },
            recordData: {
                type: DataTypes.JSONB,
                allowNull: false
            },
            deviceId: {
                type: DataTypes.TEXT,
                allowNull: false
            },
            version: {
                type: DataTypes.TEXT,
                allowNull: false
            },
            reason: {
                type: DataTypes.TEXT,
                allowNull: true
            }
        }, {
            ...options,
            tableName: 'changes',
            syncDirection: SYNC_DIRECTIONS.DO_NOT_SYNC,
            schema: 'logs',
            timestamps: false
        });
    }
    static initRelations(models) {
        this.belongsTo(models.User, {
            foreignKey: 'updatedByUserId',
            as: 'updatedByUser'
        });
    }
}

//# sourceMappingURL=ChangeLog.js.map