/**
 * Registers the Sequelize instance's dialect QueryGenerator, so that its quote() function can be
 * used by composite stringifiers.
 *
 * Keeps a WeakRef, so as to not prevent garbage collection of Sequelize.
 */
export function setupQuote(sequelizeInstance: any): void;
/**
 * Implements composite record literal syntax from
 * https://www.postgresql.org/docs/current/rowtypes.html#ROWTYPES-IO-SYNTAX
 *
 * The fields passed here should not be escaped/quoted, due to the specifics of the record syntax.
 *
 * This does *not* do the final quoting to pass as a string, which is taken care of by Sequelize.
 */
export function compositeToSql(fieldSet: any): string;
//# sourceMappingURL=stringifier.d.ts.map