"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
Object.defineProperty(exports, "createLabRequest", {
    enumerable: true,
    get: function() {
        return createLabRequest;
    }
});
const _lodash = require("lodash");
const _index = require("../../fake/index.js");
const createLabRequest = async ({ models, limit, departmentId, userId, encounterId, referenceDataId, patientId, labTestTypeId, testCount = _index.chance.integer({
    min: 1,
    max: 10
}) })=>{
    const { LabRequest, LabRequestLog, LabTest, CertificateNotification } = models;
    const labRequest = await LabRequest.create((0, _index.fake)(LabRequest, {
        departmentId,
        collectedById: userId,
        encounter: encounterId
    }));
    await LabRequestLog.create((0, _index.fake)(LabRequestLog, {
        status: 'reception_pending',
        labRequestId: labRequest.id
    }));
    await Promise.all((0, _lodash.times)(testCount, ()=>limit(async ()=>{
            const labTest = await LabTest.create((0, _index.fake)(LabTest, {
                labRequestId: labRequest.id,
                categoryId: referenceDataId,
                labTestMethodId: referenceDataId,
                labTestTypeId
            }));
            await CertificateNotification.create((0, _index.fake)(CertificateNotification, {
                patientId,
                labTestId: labTest.id,
                labRequestId: labRequest.id
            }));
        })));
};

//# sourceMappingURL=labRequest.js.map