import { GENERAL_IMPORTABLE_DATA_TYPES } from './importable';

const REFERENCE_TYPES_NOUNS = GENERAL_IMPORTABLE_DATA_TYPES.map(
  noun => String(noun).charAt(0).toUpperCase() + String(noun).slice(1),
);

export const PERMISSION_NOUNS = [
  ...REFERENCE_TYPES_NOUNS,
  'all',
  'AdministeredVaccine',
  'Appointment',
  'Asset',
  'Attachment',
  'CertificateNotification',
  'CertifiableVaccine',
  'Charting',
  'Department',
  'Discharge',
  'DocumentMetadata',
  'Encounter',
  'EncounterDiagnosis',
  'EncounterNote',
  'Facility',
  'ImagingRequest',
  'ImagingAreaExternalCode',
  'Invoice',
  'InvoicePayment',
  'InvoiceProduct',
  'IPSRequest',
  'LabRequest',
  'LabRequestLog',
  'LabRequestStatus',
  'LabTest',
  'LabTestPanel',
  'LabTestResult',
  'LabTestType',
  'Location',
  'LocationGroup',
  'Medication',
  'MedicationAdministration',
  'MedicationPharmacyNote',
  'OtherPractitionerEncounterNote',
  'Patient',
  'PatientAllergy',
  'PatientBirthData',
  'PatientCarePlan',
  'PatientCondition',
  'PatientDeath',
  'PatientDeathData',
  'PatientFamilyHistory',
  'PatientIssue',
  'PatientLetterTemplate',
  'PatientProgramRegistration',
  'PatientProgramRegistrationCondition',
  'PatientSecondaryId',
  'PatientVaccine',
  'Permission',
  'Procedure',
  'Program',
  'ProgramRegistry',
  'ProgramRegistryClinicalStatus',
  'ProgramRegistryCondition',
  'ProgramRegistryConditionCategory',
  'ReferenceData',
  'Referral',
  'ReportDbSchema',
  'ReportDefinition',
  'ReportDefinitionVersion',
  'ReportRequest',
  'Role',
  'SensitiveLabRequest',
  'Setting',
  'Signer',
  'StaticReport',
  'Survey',
  'SurveyResponse',
  'Tasking',
  'Template',
  'Translation',
  'TranslatedString',
  'TreatmentPlan',
  'TreatmentPlanNote',
  'Triage',
  'User',
  'Vitals',
  'SensitiveMedication',
];

export const NOUNS_WITH_OBJECT_ID = [
  'Survey',
  'StaticReport',
  'ReportDefinition',
  'ProgramRegistry',
];
