"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
function _export(target, all) {
    for(var name in all)Object.defineProperty(target, name, {
        enumerable: true,
        get: all[name]
    });
}
_export(exports, {
    down: function() {
        return down;
    },
    up: function() {
        return up;
    }
});
const _sequelize = /*#__PURE__*/ _interop_require_default(require("sequelize"));
function _interop_require_default(obj) {
    return obj && obj.__esModule ? obj : {
        default: obj
    };
}
async function up(query) {
    await query.addColumn('imaging_request_areas', 'marked_for_push', {
        type: _sequelize.default.BOOLEAN,
        allowNull: false,
        defaultValue: true
    });
    await query.addColumn('imaging_request_areas', 'is_pushing', {
        type: _sequelize.default.BOOLEAN,
        allowNull: false,
        defaultValue: false
    });
    await query.addColumn('imaging_request_areas', 'pushed_at', {
        type: _sequelize.default.DATE,
        allowNull: true
    });
    await query.addColumn('imaging_request_areas', 'pulled_at', {
        type: _sequelize.default.DATE,
        allowNull: true
    });
}
async function down(query) {
    await query.removeColumn('imaging_request_areas', 'marked_for_push');
    await query.removeColumn('imaging_request_areas', 'is_pushing');
    await query.removeColumn('imaging_request_areas', 'pushed_at');
    await query.removeColumn('imaging_request_areas', 'pulled_at');
}

//# sourceMappingURL=097_addSyncColumnsImagingRequestAreas.js.map