"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
Object.defineProperty(exports, // eslint-disable-next-line no-unused-vars
"default", {
    enumerable: true,
    get: function() {
        return errorHandler;
    }
});
const _sequelize = require("sequelize");
const _database = require("@tamanu/database");
const _errors = require("@tamanu/errors");
const _logging = require("@tamanu/shared/services/logging");
function errorHandler(error, req, res, _) {
    if (error instanceof _sequelize.BaseError) {
        error = (0, _database.convertDatabaseError)(error);
    }
    const problem = (error instanceof _errors.Problem ? error : _errors.Problem.fromError(error)).excludeSensitiveFields(process.env.NODE_ENV === 'production');
    if (problem.type.includes('auth')) {
        _logging.log.warn(`Error ${problem.status} (${problem.type}): ${error.message}`);
    } else if (problem.status >= 500) {
        _logging.log.error(`Error ${problem.status} (${problem.type}): `, error);
    } else {
        _logging.log.info(`Error ${problem.status} (${problem.type}): `, error);
    }
    // we're past the point of permission checking; this just
    // makes sure the error send doesn't get intercepted by the
    // permissions middleware
    if (req.flagPermissionChecked) {
        req.flagPermissionChecked();
    }
    res.set(problem.headers);
    res.status(problem.status).send({
        ...problem.toJSON(),
        error: {
            message: error.message,
            ...error
        }
    });
}

//# sourceMappingURL=errorHandler.js.map