"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
function _export(target, all) {
    for(var name in all)Object.defineProperty(target, name, {
        enumerable: true,
        get: all[name]
    });
}
_export(exports, {
    buildErrorHandler: function() {
        return buildErrorHandler;
    },
    defaultErrorHandler: function() {
        return defaultErrorHandler;
    }
});
const _sequelize = require("sequelize");
const _database = require("@tamanu/database");
const _errors = require("@tamanu/errors");
const _logging = require("@tamanu/shared/services/logging");
const buildErrorHandler = (getResponse)=>(error, req, res, next)=>{
        // see https://expressjs.com/en/guide/error-handling.html#the-default-error-handler
        if (res.headersSent) {
            next(error);
            return;
        }
        if (error instanceof _sequelize.BaseError) {
            error = (0, _database.convertDatabaseError)(error);
        }
        const problem = (error instanceof _errors.Problem ? error : _errors.Problem.fromError(error)).excludeSensitiveFields(process.env.NODE_ENV === 'production');
        if (problem.status >= 500) {
            _logging.log.error(`Error ${problem.status} (${problem.type}): `, error);
        } else {
            _logging.log.info(`Error ${problem.status} (${problem.type}): `, error);
        }
        res.set(problem.headers);
        res.status(problem.status).send(getResponse(error, problem.toJSON()));
    };
const defaultErrorHandler = buildErrorHandler((error, problem)=>({
        // RFC 7807 Problem Details for HTTP APIs
        ...problem,
        // legacy error format
        error: {
            message: error.message,
            name: error.name
        }
    }));

//# sourceMappingURL=errorHandler.js.map