export declare const DRUG_ROUTES: {
    dermal: string;
    ear: string;
    eye: string;
    intramuscular: string;
    intravenous: string;
    inhaled: string;
    nasal: string;
    oral: string;
    rectal: string;
    subcutaneous: string;
    sublingual: string;
    topical: string;
    vaginal: string;
};
export declare const DRUG_ROUTE_VALUES: string[];
export declare const DRUG_ROUTE_LABELS: {
    [DRUG_ROUTES.dermal]: string;
    [DRUG_ROUTES.ear]: string;
    [DRUG_ROUTES.eye]: string;
    [DRUG_ROUTES.intramuscular]: string;
    [DRUG_ROUTES.intravenous]: string;
    [DRUG_ROUTES.inhaled]: string;
    [DRUG_ROUTES.nasal]: string;
    [DRUG_ROUTES.oral]: string;
    [DRUG_ROUTES.rectal]: string;
    [DRUG_ROUTES.subcutaneous]: string;
    [DRUG_ROUTES.sublingual]: string;
    [DRUG_ROUTES.topical]: string;
    [DRUG_ROUTES.vaginal]: string;
};
export declare const DRUG_UNITS: {
    percentage: string;
    capsule: string;
    disc: string;
    douche: string;
    drop: string;
    ffu: string;
    g: string;
    iu: string;
    l: string;
    lozenge: string;
    mg: string;
    mcg: string;
    ml: string;
    mmol: string;
    mol: string;
    patch: string;
    pellet: string;
    pouch: string;
    puff: string;
    ring: string;
    smear: string;
    spray: string;
    stick: string;
    strip: string;
    suppository: string;
    swab: string;
    tablet: string;
    tbsp: string;
    tsp: string;
    u: string;
    vial: string;
    wafer: string;
};
export declare const DRUG_UNIT_VALUES: string[];
export declare const DRUG_UNIT_LABELS: any;
export declare const DRUG_UNIT_SHORT_LABELS: {
    [DRUG_UNITS.percentage]: string;
    [DRUG_UNITS.capsule]: string;
    [DRUG_UNITS.disc]: string;
    [DRUG_UNITS.douche]: string;
    [DRUG_UNITS.drop]: string;
    [DRUG_UNITS.ffu]: string;
    [DRUG_UNITS.g]: string;
    [DRUG_UNITS.iu]: string;
    [DRUG_UNITS.l]: string;
    [DRUG_UNITS.lozenge]: string;
    [DRUG_UNITS.mg]: string;
    [DRUG_UNITS.mcg]: string;
    [DRUG_UNITS.ml]: string;
    [DRUG_UNITS.mmol]: string;
    [DRUG_UNITS.mol]: string;
    [DRUG_UNITS.patch]: string;
    [DRUG_UNITS.pellet]: string;
    [DRUG_UNITS.pouch]: string;
    [DRUG_UNITS.puff]: string;
    [DRUG_UNITS.ring]: string;
    [DRUG_UNITS.smear]: string;
    [DRUG_UNITS.spray]: string;
    [DRUG_UNITS.stick]: string;
    [DRUG_UNITS.strip]: string;
    [DRUG_UNITS.suppository]: string;
    [DRUG_UNITS.swab]: string;
    [DRUG_UNITS.tablet]: string;
    [DRUG_UNITS.tbsp]: string;
    [DRUG_UNITS.tsp]: string;
    [DRUG_UNITS.u]: string;
    [DRUG_UNITS.vial]: string;
    [DRUG_UNITS.wafer]: string;
};
export declare const REPEATS_LABELS: number[];
export declare const ADMINISTRATION_FREQUENCIES: {
    DAILY_IN_THE_MORNING: string;
    DAILY_AT_MIDDAY: string;
    DAILY_AT_NIGHT: string;
    DAILY: string;
    TWO_TIMES_DAILY: string;
    THREE_TIMES_DAILY: string;
    FOUR_TIMES_DAILY: string;
    EVERY_4_HOURS: string;
    EVERY_6_HOURS: string;
    EVERY_8_HOURS: string;
    EVERY_SECOND_DAY: string;
    ONCE_A_WEEK: string;
    ONCE_A_MONTH: string;
    IMMEDIATELY: string;
    AS_DIRECTED: string;
    TWICE_DAILY_AM_AND_MIDDAY: string;
};
export declare const ADMINISTRATION_FREQUENCY_SYNONYMS: {
    [ADMINISTRATION_FREQUENCIES.DAILY_IN_THE_MORNING]: string[];
    [ADMINISTRATION_FREQUENCIES.DAILY_AT_MIDDAY]: string[];
    [ADMINISTRATION_FREQUENCIES.DAILY_AT_NIGHT]: string[];
    [ADMINISTRATION_FREQUENCIES.DAILY]: string[];
    [ADMINISTRATION_FREQUENCIES.TWO_TIMES_DAILY]: string[];
    [ADMINISTRATION_FREQUENCIES.THREE_TIMES_DAILY]: string[];
    [ADMINISTRATION_FREQUENCIES.FOUR_TIMES_DAILY]: string[];
    [ADMINISTRATION_FREQUENCIES.EVERY_4_HOURS]: string[];
    [ADMINISTRATION_FREQUENCIES.EVERY_6_HOURS]: string[];
    [ADMINISTRATION_FREQUENCIES.EVERY_8_HOURS]: string[];
    [ADMINISTRATION_FREQUENCIES.EVERY_SECOND_DAY]: string[];
    [ADMINISTRATION_FREQUENCIES.ONCE_A_WEEK]: string[];
    [ADMINISTRATION_FREQUENCIES.ONCE_A_MONTH]: string[];
    [ADMINISTRATION_FREQUENCIES.IMMEDIATELY]: string[];
    [ADMINISTRATION_FREQUENCIES.AS_DIRECTED]: string[];
    [ADMINISTRATION_FREQUENCIES.TWICE_DAILY_AM_AND_MIDDAY]: string[];
};
export declare const ADMINISTRATION_FREQUENCY_DETAILS: {
    [ADMINISTRATION_FREQUENCIES.DAILY_IN_THE_MORNING]: {
        startTimes: string[];
        dosesPerDay: number;
    };
    [ADMINISTRATION_FREQUENCIES.DAILY_AT_MIDDAY]: {
        startTimes: string[];
        dosesPerDay: number;
    };
    [ADMINISTRATION_FREQUENCIES.DAILY_AT_NIGHT]: {
        startTimes: string[];
        dosesPerDay: number;
    };
    [ADMINISTRATION_FREQUENCIES.DAILY]: {
        startTimes: string[];
        dosesPerDay: number;
    };
    [ADMINISTRATION_FREQUENCIES.TWO_TIMES_DAILY]: {
        startTimes: string[];
        dosesPerDay: number;
    };
    [ADMINISTRATION_FREQUENCIES.THREE_TIMES_DAILY]: {
        startTimes: string[];
        dosesPerDay: number;
    };
    [ADMINISTRATION_FREQUENCIES.FOUR_TIMES_DAILY]: {
        startTimes: string[];
        dosesPerDay: number;
    };
    [ADMINISTRATION_FREQUENCIES.EVERY_4_HOURS]: {
        startTimes: string[];
        dosesPerDay: number;
    };
    [ADMINISTRATION_FREQUENCIES.EVERY_6_HOURS]: {
        startTimes: string[];
        dosesPerDay: number;
    };
    [ADMINISTRATION_FREQUENCIES.EVERY_8_HOURS]: {
        startTimes: string[];
        dosesPerDay: number;
    };
    [ADMINISTRATION_FREQUENCIES.EVERY_SECOND_DAY]: {
        startTimes: string[];
        dosesPerDay: number;
    };
    [ADMINISTRATION_FREQUENCIES.ONCE_A_WEEK]: {
        startTimes: string[];
        dosesPerDay: number;
    };
    [ADMINISTRATION_FREQUENCIES.ONCE_A_MONTH]: {
        startTimes: string[];
        dosesPerDay: number;
    };
    [ADMINISTRATION_FREQUENCIES.IMMEDIATELY]: {
        startTimes: null;
        dosesPerDay: null;
    };
    [ADMINISTRATION_FREQUENCIES.AS_DIRECTED]: {
        startTimes: null;
        dosesPerDay: null;
    };
    [ADMINISTRATION_FREQUENCIES.TWICE_DAILY_AM_AND_MIDDAY]: {
        startTimes: string[];
        dosesPerDay: number;
    };
};
export declare const MEDICATION_DURATION_UNITS: {
    [key: string]: keyof Duration;
};
export declare const MEDICATION_DURATION_DISPLAY_UNITS_LABELS: {
    [x: string]: string;
};
export declare const MEDICATION_DURATION_UNITS_LABELS: {
    [x: string]: string;
};
export declare const MEDICATION_PAUSE_DURATION_UNITS_LABELS: {
    [x: string]: string;
};
export declare const ADMINISTRATION_STATUS: {
    GIVEN: string;
    NOT_GIVEN: string;
};
export declare const ADMINISTRATION_STATUS_LABELS: {
    [ADMINISTRATION_STATUS.GIVEN]: string;
    [ADMINISTRATION_STATUS.NOT_GIVEN]: string;
};
export declare const MEDICATION_ADMINISTRATION_TIME_SLOTS: ({
    startTime: string;
    endTime: string;
    periodLabel?: undefined;
} | {
    startTime: string;
    endTime: string;
    periodLabel: string;
})[];
//# sourceMappingURL=medications.d.ts.map