"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
Object.defineProperty(exports, "invoiceItemsRoute", {
    enumerable: true,
    get: function() {
        return invoiceItemsRoute;
    }
});
const _crudHelpers = require("@tamanu/shared/utils/crudHelpers");
const _expressasynchandler = /*#__PURE__*/ _interop_require_default(require("express-async-handler"));
const _getPotentialInvoiceItems = require("./getPotentialInvoiceItems");
const _lodash = require("lodash");
function _interop_require_default(obj) {
    return obj && obj.__esModule ? obj : {
        default: obj
    };
}
const invoiceItemsRoute = (0, _crudHelpers.permissionCheckingRouter)('read', 'Invoice');
invoiceItemsRoute.get('/:id/items', (0, _crudHelpers.simpleGetList)('InvoiceItem', 'invoiceId', {
    skipPermissionCheck: true
}));
invoiceItemsRoute.get('/:id/potentialInvoiceItems', (0, _expressasynchandler.default)(async (req, res)=>{
    const localisation = await req.getLocalisation();
    const data = await (0, _getPotentialInvoiceItems.getPotentialInvoiceItems)(req.db, req.params.id, Object.keys(localisation?.imagingTypes ?? {}));
    const transformedData = data.map((it)=>(0, _lodash.transform)(it, (result, value, key)=>{
            (0, _lodash.set)(result, key, value);
        }, {}));
    res.json({
        count: transformedData.length,
        data: transformedData
    });
}));

//# sourceMappingURL=invoiceItems.js.map