"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
function _export(target, all) {
    for(var name in all)Object.defineProperty(target, name, {
        enumerable: true,
        get: all[name]
    });
}
_export(exports, {
    APPOINTMENT_STATUSES: function() {
        return APPOINTMENT_STATUSES;
    },
    APPOINTMENT_STATUS_VALUES: function() {
        return APPOINTMENT_STATUS_VALUES;
    },
    COMMUNICATION_STATUSES: function() {
        return COMMUNICATION_STATUSES;
    },
    COMMUNICATION_STATUSES_VALUES: function() {
        return COMMUNICATION_STATUSES_VALUES;
    },
    IMAGING_REQUEST_STATUS_CONFIG: function() {
        return IMAGING_REQUEST_STATUS_CONFIG;
    },
    IMAGING_REQUEST_STATUS_LABELS: function() {
        return IMAGING_REQUEST_STATUS_LABELS;
    },
    IMAGING_REQUEST_STATUS_TYPES: function() {
        return IMAGING_REQUEST_STATUS_TYPES;
    },
    JOB_QUEUE_STATUSES: function() {
        return JOB_QUEUE_STATUSES;
    },
    PORTAL_USER_STATUSES: function() {
        return PORTAL_USER_STATUSES;
    },
    PORTAL_USER_STATUS_LABELS: function() {
        return PORTAL_USER_STATUS_LABELS;
    },
    PORTAL_USER_STATUS_VALUES: function() {
        return PORTAL_USER_STATUS_VALUES;
    },
    REFERRAL_STATUSES: function() {
        return REFERRAL_STATUSES;
    },
    REFERRAL_STATUS_LABELS: function() {
        return REFERRAL_STATUS_LABELS;
    }
});
const _colors = require("./colors.js");
const IMAGING_REQUEST_STATUS_TYPES = {
    PENDING: 'pending',
    IN_PROGRESS: 'in_progress',
    COMPLETED: 'completed',
    CANCELLED: 'cancelled',
    DELETED: 'deleted',
    ENTERED_IN_ERROR: 'entered_in_error'
};
const IMAGING_REQUEST_STATUS_LABELS = {
    [IMAGING_REQUEST_STATUS_TYPES.PENDING]: 'Pending',
    [IMAGING_REQUEST_STATUS_TYPES.IN_PROGRESS]: 'In progress',
    [IMAGING_REQUEST_STATUS_TYPES.COMPLETED]: 'Completed',
    [IMAGING_REQUEST_STATUS_TYPES.CANCELLED]: 'Cancelled',
    [IMAGING_REQUEST_STATUS_TYPES.DELETED]: 'Deleted',
    [IMAGING_REQUEST_STATUS_TYPES.ENTERED_IN_ERROR]: 'Entered in error'
};
const IMAGING_REQUEST_STATUS_CONFIG = {
    [IMAGING_REQUEST_STATUS_TYPES.PENDING]: {
        label: IMAGING_REQUEST_STATUS_LABELS[IMAGING_REQUEST_STATUS_TYPES.PENDING],
        color: _colors.COLORS.darkOrange,
        background: '#FAF0E6'
    },
    [IMAGING_REQUEST_STATUS_TYPES.COMPLETED]: {
        label: IMAGING_REQUEST_STATUS_LABELS[IMAGING_REQUEST_STATUS_TYPES.COMPLETED],
        color: _colors.COLORS.green,
        background: '#DEF0EE'
    },
    [IMAGING_REQUEST_STATUS_TYPES.IN_PROGRESS]: {
        label: IMAGING_REQUEST_STATUS_LABELS[IMAGING_REQUEST_STATUS_TYPES.IN_PROGRESS],
        color: _colors.COLORS.purple,
        background: '#ECE6FA'
    },
    [IMAGING_REQUEST_STATUS_TYPES.CANCELLED]: {
        label: IMAGING_REQUEST_STATUS_LABELS[IMAGING_REQUEST_STATUS_TYPES.CANCELLED],
        color: _colors.COLORS.grey,
        background: '#EDEDED'
    },
    [IMAGING_REQUEST_STATUS_TYPES.DELETED]: {
        label: IMAGING_REQUEST_STATUS_LABELS[IMAGING_REQUEST_STATUS_TYPES.DELETED],
        color: _colors.COLORS.grey,
        background: '#EDEDED'
    },
    [IMAGING_REQUEST_STATUS_TYPES.ENTERED_IN_ERROR]: {
        label: IMAGING_REQUEST_STATUS_LABELS[IMAGING_REQUEST_STATUS_TYPES.ENTERED_IN_ERROR],
        color: _colors.COLORS.grey,
        background: '#EDEDED'
    }
};
const APPOINTMENT_STATUSES = {
    CONFIRMED: 'Confirmed',
    ARRIVED: 'Arrived',
    ASSESSED: 'Assessed',
    SEEN: 'Seen',
    NO_SHOW: 'No-show',
    CANCELLED: 'Cancelled'
};
const APPOINTMENT_STATUS_VALUES = Object.values(APPOINTMENT_STATUSES);
const REFERRAL_STATUSES = {
    PENDING: 'pending',
    CANCELLED: 'cancelled',
    COMPLETED: 'completed'
};
const REFERRAL_STATUS_LABELS = {
    [REFERRAL_STATUSES.PENDING]: 'Pending',
    [REFERRAL_STATUSES.CANCELLED]: 'Cancelled',
    [REFERRAL_STATUSES.COMPLETED]: 'Completed'
};
const COMMUNICATION_STATUSES = {
    QUEUED: 'Queued',
    PROCESSED: 'Processed',
    SENT: 'Sent',
    ERROR: 'Error',
    DELIVERED: 'Delivered',
    BAD_FORMAT: 'Bad Format'
};
const JOB_QUEUE_STATUSES = {
    QUEUED: 'Queued',
    STARTED: 'Started',
    COMPLETED: 'Completed',
    ERRORED: 'Errored'
};
const COMMUNICATION_STATUSES_VALUES = Object.values(COMMUNICATION_STATUSES);
const PORTAL_USER_STATUSES = {
    PENDING: 'pending',
    REGISTERED: 'registered'
};
const PORTAL_USER_STATUS_LABELS = {
    [PORTAL_USER_STATUSES.PENDING]: 'Pending',
    [PORTAL_USER_STATUSES.REGISTERED]: 'Registered'
};
const PORTAL_USER_STATUS_VALUES = Object.values(PORTAL_USER_STATUSES);

//# sourceMappingURL=statuses.js.map