"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
Object.defineProperty(exports, "ImagingAreaExternalCode", {
    enumerable: true,
    get: function() {
        return ImagingAreaExternalCode;
    }
});
const _sequelize = require("sequelize");
const _constants = require("@tamanu/constants");
const _errors = require("@tamanu/errors");
const _Model = require("./Model");
let ImagingAreaExternalCode = class ImagingAreaExternalCode extends _Model.Model {
    static initModel({ primaryKey, ...options }) {
        super.init({
            id: primaryKey,
            visibilityStatus: {
                type: _sequelize.DataTypes.TEXT,
                allowNull: false,
                defaultValue: 'current'
            },
            code: {
                type: _sequelize.DataTypes.TEXT,
                allowNull: false
            },
            description: _sequelize.DataTypes.TEXT
        }, {
            ...options,
            // This is reference/imported data
            syncDirection: _constants.SYNC_DIRECTIONS.PULL_FROM_CENTRAL,
            validate: {
                mustHaveVaccine () {
                    if (!this.deletedAt && !this.areaId) {
                        throw new _errors.InvalidOperationError('An imaging area external code must have an area.');
                    }
                }
            }
        });
    }
    static getListReferenceAssociations() {
        return [
            'area'
        ];
    }
    static initRelations(models) {
        this.belongsTo(models.ReferenceData, {
            foreignKey: 'areaId',
            as: 'area'
        });
    }
    static buildSyncFilter() {
        return null; // syncs everywhere
    }
    static async buildSyncLookupQueryDetails() {
        return null; // syncs everywhere
    }
};

//# sourceMappingURL=ImagingAreaExternalCode.js.map