import { EndpointKey } from 'mushi';
import { Model } from './Model';
import type { InitOptions } from '../types/model';
import type * as Facts from '@tamanu/constants/facts';
export type FactName = (typeof Facts)[keyof typeof Facts];
export declare class LocalSystemFact extends Model {
    id: string;
    key: string;
    value?: string;
    static initModel({ primaryKey, ...options }: InitOptions): void;
    static get(key: FactName): Promise<string | null>;
    static set(key: FactName, value?: string): Promise<void>;
    static setIfAbsent(key: FactName, value?: string): Promise<void>;
    static incrementValue(key: FactName, amount?: number): Promise<number>;
    static delete(key: FactName): Promise<void>;
    static getDeviceKey(): Promise<EndpointKey>;
    static getLookupModelsToRebuild(): Promise<string[]>;
    static isLookupRebuildingModel(modelName: string): Promise<boolean>;
    static markLookupModelRebuilt(modelName: string): Promise<void>;
}
//# sourceMappingURL=LocalSystemFact.d.ts.map