"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
Object.defineProperty(exports, "ongoingCondition", {
    enumerable: true,
    get: function() {
        return ongoingCondition;
    }
});
const _express = /*#__PURE__*/ _interop_require_default(require("express"));
const _expressasynchandler = /*#__PURE__*/ _interop_require_default(require("express-async-handler"));
const _errors = require("@tamanu/errors");
const _crudHelpers = require("@tamanu/shared/utils/crudHelpers");
function _interop_require_default(obj) {
    return obj && obj.__esModule ? obj : {
        default: obj
    };
}
const ongoingCondition = _express.default.Router();
ongoingCondition.get('/:id', (0, _crudHelpers.simpleGet)('PatientCondition', {
    auditAccess: true
}));
ongoingCondition.put('/:id', (0, _crudHelpers.simplePut)('PatientCondition'));
ongoingCondition.post('/$', (0, _crudHelpers.simplePost)('PatientCondition'));
ongoingCondition.delete('/:id', (0, _expressasynchandler.default)(async (req, res)=>{
    const { models, params } = req;
    req.checkPermission('delete', 'PatientCondition');
    const condition = await models.PatientCondition.findByPk(params.id);
    if (!condition) {
        throw new _errors.NotFoundError('Ongoing condition not found');
    }
    await condition.destroy();
    res.status(200).send({
        message: 'Ongoing condition deleted successfully'
    });
}));

//# sourceMappingURL=ongoingCondition.js.map