"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
function _export(target, all) {
    for(var name in all)Object.defineProperty(target, name, {
        enumerable: true,
        get: all[name]
    });
}
_export(exports, {
    buildErrorHandler: function() {
        return buildErrorHandler;
    },
    defaultErrorHandler: function() {
        return defaultErrorHandler;
    }
});
const _database = require("@tamanu/database");
const _utils = require("@tamanu/shared/utils");
const buildErrorHandler = (getResponse)=>(error, req, res, next)=>{
        // see https://expressjs.com/en/guide/error-handling.html#the-default-error-handler
        if (res.headersSent) {
            next(error);
            return;
        }
        const { problem, json } = (0, _utils.errorHandlerProblem)(error, req, {
            convertDatabaseError: _database.convertDatabaseError
        });
        res.set(problem.headers);
        res.status(problem.status).send(getResponse(error, json));
    };
const defaultErrorHandler = buildErrorHandler((_error, defaultJson)=>defaultJson);

//# sourceMappingURL=errorHandler.js.map