"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
function _export(target, all) {
    for(var name in all)Object.defineProperty(target, name, {
        enumerable: true,
        get: all[name]
    });
}
_export(exports, {
    AVPU_LABELS: function() {
        return AVPU_LABELS;
    },
    AVPU_OPTIONS: function() {
        return AVPU_OPTIONS;
    },
    AVPU_TYPES: function() {
        return AVPU_TYPES;
    },
    DIAGNOSIS_CERTAINTIES_TO_HIDE: function() {
        return DIAGNOSIS_CERTAINTIES_TO_HIDE;
    },
    DIAGNOSIS_CERTAINTY: function() {
        return DIAGNOSIS_CERTAINTY;
    },
    DIAGNOSIS_CERTAINTY_LABELS: function() {
        return DIAGNOSIS_CERTAINTY_LABELS;
    },
    DIAGNOSIS_CERTAINTY_VALUES: function() {
        return DIAGNOSIS_CERTAINTY_VALUES;
    },
    PATIENT_ISSUE_LABELS: function() {
        return PATIENT_ISSUE_LABELS;
    },
    PATIENT_ISSUE_TYPES: function() {
        return PATIENT_ISSUE_TYPES;
    }
});
const PATIENT_ISSUE_TYPES = {
    ISSUE: 'issue',
    WARNING: 'warning'
};
const PATIENT_ISSUE_LABELS = {
    [PATIENT_ISSUE_TYPES.ISSUE]: 'Issue',
    [PATIENT_ISSUE_TYPES.WARNING]: 'Warning'
};
const AVPU_TYPES = {
    ALERT: 'alert',
    VERBAL: 'verbal',
    PAIN: 'pain',
    UNRESPONSIVE: 'unresponsive'
};
const AVPU_LABELS = {
    [AVPU_TYPES.ALERT]: 'Alert',
    [AVPU_TYPES.VERBAL]: 'Verbal',
    [AVPU_TYPES.PAIN]: 'Pain',
    [AVPU_TYPES.UNRESPONSIVE]: 'Unresponsive'
};
const AVPU_OPTIONS = [
    {
        value: AVPU_TYPES.ALERT,
        label: AVPU_LABELS[AVPU_TYPES.ALERT]
    },
    {
        value: AVPU_TYPES.VERBAL,
        label: AVPU_LABELS[AVPU_TYPES.VERBAL]
    },
    {
        value: AVPU_TYPES.PAIN,
        label: AVPU_LABELS[AVPU_TYPES.PAIN]
    },
    {
        value: AVPU_TYPES.UNRESPONSIVE,
        label: AVPU_LABELS[AVPU_TYPES.UNRESPONSIVE]
    }
];
const DIAGNOSIS_CERTAINTY = {
    SUSPECTED: 'suspected',
    CONFIRMED: 'confirmed',
    EMERGENCY: 'emergency',
    DISPROVEN: 'disproven',
    ERROR: 'error'
};
const DIAGNOSIS_CERTAINTY_LABELS = {
    [DIAGNOSIS_CERTAINTY.EMERGENCY]: 'ED Diagnosis',
    [DIAGNOSIS_CERTAINTY.SUSPECTED]: 'Suspected',
    [DIAGNOSIS_CERTAINTY.CONFIRMED]: 'Confirmed',
    [DIAGNOSIS_CERTAINTY.DISPROVEN]: 'Disproven',
    [DIAGNOSIS_CERTAINTY.ERROR]: 'Recorded in error'
};
const DIAGNOSIS_CERTAINTY_VALUES = Object.values(DIAGNOSIS_CERTAINTY);
const DIAGNOSIS_CERTAINTIES_TO_HIDE = [
    DIAGNOSIS_CERTAINTY.DISPROVEN,
    DIAGNOSIS_CERTAINTY.ERROR
];

//# sourceMappingURL=diagnoses.js.map