"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
function _export(target, all) {
    for(var name in all)Object.defineProperty(target, name, {
        enumerable: true,
        get: all[name]
    });
}
_export(exports, {
    down: function() {
        return down;
    },
    up: function() {
        return up;
    }
});
const _sequelize = /*#__PURE__*/ _interop_require_default(require("sequelize"));
function _interop_require_default(obj) {
    return obj && obj.__esModule ? obj : {
        default: obj
    };
}
async function up(query) {
    await query.createTable('lab_request_attachments', {
        id: {
            type: _sequelize.default.STRING,
            defaultValue: _sequelize.default.fn('uuid_generate_v4'),
            allowNull: false,
            primaryKey: true
        },
        created_at: {
            type: _sequelize.default.DATE,
            defaultValue: _sequelize.default.fn('current_timestamp', 3),
            allowNull: false
        },
        updated_at: {
            type: _sequelize.default.DATE,
            defaultValue: _sequelize.default.fn('current_timestamp', 3),
            allowNull: false
        },
        deleted_at: {
            type: _sequelize.default.DATE,
            allowNull: true
        },
        attachment_id: {
            type: _sequelize.default.STRING,
            allowNull: false
        },
        lab_request_id: {
            type: _sequelize.default.STRING,
            allowNull: false,
            references: {
                model: 'lab_requests',
                key: 'id'
            }
        },
        title: {
            type: _sequelize.default.STRING,
            allowNull: true
        },
        replaced_by_id: {
            type: _sequelize.default.STRING,
            allowNull: true
        }
    });
}
async function down(query) {
    await query.dropTable('lab_request_attachments');
}

//# sourceMappingURL=1712623959724-createLabRequestAttachments.js.map